/*
 * Decompiled with CFR 0.152.
 */
package restx.tests.json;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import restx.common.MorePreconditions;
import restx.tests.json.JsonObjectLocation;
import restx.tests.json.JsonWithLocationsParser;

public class JsonDiff {
    private final JsonWithLocationsParser.ParsedJsonWithLocations leftObj;
    private final JsonWithLocationsParser.ParsedJsonWithLocations rightObj;
    private List<Difference> differences = new ArrayList<Difference>();
    private List<String> currentLeftPath = new LinkedList<String>(Arrays.asList("."));
    private List<String> currentRightPath = new LinkedList<String>(Arrays.asList("."));
    private Map<String, Object> leftContexts = new LinkedHashMap<String, Object>();
    private Map<String, Object> rightContexts = new LinkedHashMap<String, Object>();
    private Map<String, Setter> leftSetters = new LinkedHashMap<String, Setter>();
    private Map<String, Setter> rightSetters = new LinkedHashMap<String, Setter>();

    public JsonDiff(JsonWithLocationsParser.ParsedJsonWithLocations leftObj, JsonWithLocationsParser.ParsedJsonWithLocations rightObj) {
        this.leftObj = leftObj;
        this.rightObj = rightObj;
        this.putContexts(new NoSetter(), leftObj.getRoot(), new NoSetter(), rightObj.getRoot());
    }

    public JsonWithLocationsParser.ParsedJsonWithLocations getLeftObj() {
        return this.leftObj;
    }

    public JsonWithLocationsParser.ParsedJsonWithLocations getRightObj() {
        return this.rightObj;
    }

    public boolean isSame() {
        return this.differences.isEmpty();
    }

    protected JsonDiff goIn(String path) {
        this.currentLeftPath.add(path);
        this.currentRightPath.add(path);
        return this;
    }

    public JsonDiff goIn(String left, String right) {
        this.currentLeftPath.add(left);
        this.currentRightPath.add(right);
        return this;
    }

    protected JsonDiff goUp() {
        this.currentLeftPath.remove(this.currentLeftPath.size() - 1);
        this.currentRightPath.remove(this.currentRightPath.size() - 1);
        return this;
    }

    protected String currentLeftPath() {
        return this.pathFor(this.currentLeftPath);
    }

    protected String currentRightPath() {
        return this.pathFor(this.currentRightPath);
    }

    public JsonDiff addDifference(Difference difference) {
        this.differences.add(difference);
        return this;
    }

    public ImmutableList<Difference> getDifferences() {
        return ImmutableList.copyOf(this.differences);
    }

    protected JsonObjectLocation contextLeft(Object o) {
        return (JsonObjectLocation)MorePreconditions.checkPresent(this.leftObj.getLocations().getLocationOf(o), (String)("can't find left context for " + o), (Object[])new Object[0]);
    }

    protected JsonObjectLocation contextRight(Object o) {
        return (JsonObjectLocation)MorePreconditions.checkPresent(this.rightObj.getLocations().getLocationOf(o), (String)("can't find right context for " + o), (Object[])new Object[0]);
    }

    public JsonDiff putContexts(Setter leftSetter, Object left, Setter rightSetter, Object right) {
        this.leftContexts.put(this.currentLeftPath(), left);
        this.leftSetters.put(this.currentLeftPath(), leftSetter);
        this.rightContexts.put(this.currentRightPath(), right);
        this.rightSetters.put(this.currentRightPath(), rightSetter);
        return this;
    }

    public JsonObjectLocation currentLeftContextLocation() {
        LinkedList<String> path = new LinkedList<String>(this.currentLeftPath);
        Optional<JsonObjectLocation> l = this.leftObj.getLocations().getLocationOf(this.leftContexts.get(this.pathFor(path)));
        while (!l.isPresent() && path.size() > 1) {
            path.remove(path.size() - 1);
            l = this.leftObj.getLocations().getLocationOf(this.leftContexts.get(this.pathFor(path)));
        }
        return (JsonObjectLocation)l.orNull();
    }

    public JsonObjectLocation currentRightContextLocation() {
        LinkedList<String> path = new LinkedList<String>(this.currentRightPath);
        Optional<JsonObjectLocation> l = this.rightObj.getLocations().getLocationOf(this.rightContexts.get(this.pathFor(path)));
        while (!l.isPresent() && path.size() > 1) {
            path.remove(path.size() - 1);
            l = this.rightObj.getLocations().getLocationOf(this.rightContexts.get(this.pathFor(path)));
        }
        return (JsonObjectLocation)l.orNull();
    }

    private String pathFor(List<String> path) {
        return Joiner.on((String)"/").join(path);
    }

    Object getLeftAt(String path) {
        return this.leftContexts.get(path);
    }

    private void setLeftAt(String path, Object value) {
        this.leftSetters.get(path).set(value);
    }

    Object getRightAt(String path) {
        return this.rightContexts.get(path);
    }

    private void setRightAt(String path, Object value) {
        this.rightSetters.get(path).set(value);
    }

    String getParentPath(String path) {
        int i = path.lastIndexOf(47);
        return i == -1 ? path : path.substring(0, i);
    }

    String getLastElementPath(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static class NoSetter
    implements Setter {
        @Override
        public void set(Object value) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface Setter {
        public void set(Object var1);
    }

    public static class MapSetter
    implements Setter {
        private final Map<String, Object> map;
        private final String key;

        public MapSetter(Map<String, Object> map, String key) {
            this.map = map;
            this.key = key;
        }

        @Override
        public void set(Object value) {
            this.map.put(this.key, value);
        }
    }

    public static class ListSetter
    implements Setter {
        private final List<Object> objects;
        private final int i;

        public ListSetter(List<Object> objects, int i) {
            this.objects = objects;
            this.i = i;
        }

        @Override
        public void set(Object value) {
            this.objects.set(this.i, value);
        }
    }

    public static class RemovedKey
    extends KeyDiff {
        public RemovedKey(String leftPath, String rightPath, JsonObjectLocation leftContext, JsonObjectLocation rightContext, String key, Object value) {
            super(leftPath, rightPath, leftContext, rightContext, key, value);
        }

        @Override
        public String getType() {
            return "REMOVED";
        }

        @Override
        public void mergeToRight(JsonDiff diff) {
            this.getRightParent(diff).put(this.getKey(), this.getValue());
        }

        @Override
        public void mergeToLeft(JsonDiff diff) {
            this.getLeftParent(diff).remove(this.getKey());
        }
    }

    public static class AddedKey
    extends KeyDiff {
        public AddedKey(String leftPath, String rightPath, JsonObjectLocation leftContext, JsonObjectLocation rightContext, String key, Object value) {
            super(leftPath, rightPath, leftContext, rightContext, key, value);
        }

        @Override
        public String getType() {
            return "ADDED";
        }

        @Override
        public void mergeToRight(JsonDiff diff) {
            this.getRightParent(diff).remove(this.getKey());
        }

        @Override
        public void mergeToLeft(JsonDiff diff) {
            this.getLeftParent(diff).put(this.getKey(), this.getValue());
        }
    }

    public static abstract class KeyDiff
    extends AbstractDiff {
        private final String key;
        private final Object value;

        protected KeyDiff(String leftPath, String rightPath, JsonObjectLocation leftContext, JsonObjectLocation rightContext, String key, Object value) {
            super(leftPath, rightPath, leftContext, rightContext);
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public String toString() {
            return "KeyDiff{" + super.toString() + ", type='" + this.getType() + "', key='" + this.key + "', value=" + this.value + "}";
        }

        protected Map<String, Object> getLeftParent(JsonDiff diff) {
            return (Map)diff.getLeftAt(this.getLeftPath());
        }

        protected Map<String, Object> getRightParent(JsonDiff diff) {
            return (Map)diff.getRightAt(this.getLeftPath());
        }
    }

    public static class ArrayDeletedValue
    extends ArrayDiff {
        public ArrayDeletedValue(String leftPath, String rightPath, JsonObjectLocation leftContext, JsonObjectLocation rightContext, int leftPosition, int rightPosition, List<Object> values) {
            super(leftPath, rightPath, leftContext, rightContext, leftPosition, rightPosition, values);
        }

        @Override
        public String getType() {
            return "DELETED";
        }

        @Override
        public void mergeToRight(JsonDiff diff) {
            List l = (List)diff.getRightAt(this.getRightPath());
            l.addAll(this.getRightPosition(), this.getValues());
        }

        @Override
        public void mergeToLeft(JsonDiff diff) {
            List l = (List)diff.getLeftAt(this.getLeftPath());
            for (int i = 0; i < this.getValues().size(); ++i) {
                l.remove(this.getLeftPosition());
            }
        }
    }

    public static class ArrayInsertedValue
    extends ArrayDiff {
        public ArrayInsertedValue(String leftPath, String rightPath, JsonObjectLocation leftContext, JsonObjectLocation rightContext, int leftPosition, int rightPosition, List<Object> values) {
            super(leftPath, rightPath, leftContext, rightContext, leftPosition, rightPosition, values);
        }

        @Override
        public String getType() {
            return "INSERTED";
        }

        @Override
        public void mergeToRight(JsonDiff diff) {
            List l = (List)diff.getRightAt(this.getRightPath());
            for (int i = 0; i < this.getValues().size(); ++i) {
                l.remove(this.getRightPosition());
            }
        }

        @Override
        public void mergeToLeft(JsonDiff diff) {
            List l = (List)diff.getLeftAt(this.getLeftPath());
            l.addAll(this.getLeftPosition(), this.getValues());
        }
    }

    public static abstract class ArrayDiff
    extends AbstractDiff {
        private final int leftPosition;
        private final int rightPosition;
        private final List<Object> values;

        public ArrayDiff(String leftPath, String rightPath, JsonObjectLocation leftContext, JsonObjectLocation rightContext, int leftPosition, int rightPosition, List<Object> values) {
            super(leftPath, rightPath, leftContext, rightContext);
            this.leftPosition = leftPosition;
            this.rightPosition = rightPosition;
            this.values = new ArrayList<Object>(values);
        }

        @Override
        public abstract String getType();

        public int getLeftPosition() {
            return this.leftPosition;
        }

        public int getRightPosition() {
            return this.rightPosition;
        }

        public List<Object> getValues() {
            return this.values;
        }

        @Override
        public String toString() {
            return "ArrayDiff{" + super.toString() + ", type=" + this.getType() + ", leftPosition=" + this.leftPosition + ", rightPosition=" + this.rightPosition + ", values=" + this.values + "}";
        }
    }

    public static class ValueDiff
    extends AbstractDiff {
        private final Object leftValue;
        private final Object rightValue;

        public ValueDiff(String leftPath, String rightPath, JsonObjectLocation leftContext, JsonObjectLocation rightContext, Object leftValue, Object rightValue) {
            super(leftPath, rightPath, leftContext, rightContext);
            this.leftValue = leftValue;
            this.rightValue = rightValue;
        }

        @Override
        public String getType() {
            return "CHANGED";
        }

        public Object getLeftValue() {
            return this.leftValue;
        }

        public Object getRightValue() {
            return this.rightValue;
        }

        @Override
        public void mergeToRight(JsonDiff diff) {
            diff.setRightAt(this.getRightPath(), this.leftValue);
        }

        @Override
        public void mergeToLeft(JsonDiff diff) {
            diff.setLeftAt(this.getLeftPath(), this.rightValue);
        }

        @Override
        public String toString() {
            return "ValueDiff{" + super.toString() + ", leftValue=" + this.leftValue + ", rightValue=" + this.rightValue + "}";
        }
    }

    public static abstract class AbstractDiff
    implements Difference {
        private final String leftPath;
        private final String rightPath;
        private final JsonObjectLocation leftContext;
        private final JsonObjectLocation rightContext;

        protected AbstractDiff(String leftPath, String rightPath, JsonObjectLocation leftContext, JsonObjectLocation rightContext) {
            this.leftPath = leftPath;
            this.rightPath = rightPath;
            this.leftContext = leftContext;
            this.rightContext = rightContext;
        }

        @Override
        public abstract String getType();

        @Override
        public String getLeftPath() {
            return this.leftPath;
        }

        @Override
        public String getRightPath() {
            return this.rightPath;
        }

        @Override
        public JsonObjectLocation getLeftContext() {
            return this.leftContext;
        }

        @Override
        public JsonObjectLocation getRightContext() {
            return this.rightContext;
        }

        @Override
        public void mergeToRight(JsonDiff diff) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void mergeToLeft(JsonDiff diff) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "Diff{leftPath='" + this.leftPath + "', rightPath='" + this.rightPath + "', leftContext=" + this.leftContext + ", rightContext=" + this.rightContext + "}";
        }
    }

    public static interface Difference {
        public String getType();

        public String getLeftPath();

        public String getRightPath();

        public JsonObjectLocation getLeftContext();

        public JsonObjectLocation getRightContext();

        public void mergeToRight(JsonDiff var1);

        public void mergeToLeft(JsonDiff var1);
    }
}

