/*
 * Decompiled with CFR 0.152.
 */
package restx.tests;

import com.chrylis.codec.base58.Base58Codec;
import com.github.kevinsawicki.http.HttpRequest;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import restx.factory.Component;
import restx.specs.ThenHttpResponse;
import restx.specs.WhenHttpRequest;
import restx.tests.HttpTestClient;
import restx.tests.WhenChecker;
import restx.tests.json.JsonAssertions;

@Component
public class WhenHttpChecker
implements WhenChecker<WhenHttpRequest> {
    private List<String> headersSession = Arrays.asList("RestxSession", "RestxSessionSignature");

    @Override
    public Class<WhenHttpRequest> getWhenClass() {
        return WhenHttpRequest.class;
    }

    @Override
    public void check(WhenHttpRequest when, ImmutableMap<String, String> params) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        String baseUrl = (String)Preconditions.checkNotNull((Object)((String)params.get((Object)"WhenHttpRequest.BASE_URL")), (Object)"WhenHttpRequest.BASE_URL param is required");
        String url = baseUrl + "/" + when.getPath();
        System.out.println("---------------------------------------------------------------------------------");
        System.out.println(">> REQUEST");
        System.out.println(when.getMethod() + " " + url);
        System.out.println();
        HttpTestClient httpTestClient = HttpTestClient.withBaseUrl(baseUrl);
        for (Map.Entry cookie : when.getCookies().entrySet()) {
            httpTestClient = httpTestClient.withCookie((String)cookie.getKey(), (String)cookie.getValue());
        }
        HttpRequest httpRequest = httpTestClient.http(when.getMethod(), when.getPath());
        ImmutableMap cookies = when.getCookies();
        if (!cookies.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : cookies.entrySet()) {
                String valueCookie = this.headersSession.contains(entry.getKey()) ? Base58Codec.doEncode((byte[])((String)entry.getValue()).getBytes()) : (String)entry.getValue();
                sb.append((String)entry.getKey()).append("=\"").append(valueCookie.replace("\"", "\\\"")).append("\"; ");
            }
            sb.setLength(sb.length() - 2);
            httpRequest.header("Cookie", sb.toString());
        }
        if (!Strings.isNullOrEmpty((String)when.getBody())) {
            httpRequest.contentType("application/json");
            httpRequest.send((CharSequence)when.getBody());
            System.out.println(when.getBody());
        }
        System.out.println();
        int code = httpRequest.code();
        System.out.println("<< RESPONSE");
        System.out.println(code);
        System.out.println();
        String body = httpRequest.body(Charsets.UTF_8.name());
        System.out.println(body);
        System.out.println();
        Assertions.assertThat((int)code).isEqualTo(((ThenHttpResponse)when.getThen()).getExpectedCode());
        if (this.isJSON(((ThenHttpResponse)when.getThen()).getExpected())) {
            JsonAssertions.assertThat(body).allowingExtraUnexpectedFields().isSameJsonAs(((ThenHttpResponse)when.getThen()).getExpected());
        } else if (!((ThenHttpResponse)when.getThen()).getExpected().trim().isEmpty()) {
            MatcherAssert.assertThat((Object)body.trim(), (Matcher)CoreMatchers.equalTo((Object)((ThenHttpResponse)when.getThen()).getExpected().trim()));
        }
        System.out.printf("checked %s /%s -- %s%n", when.getMethod(), when.getPath(), stopwatch.stop().toString());
    }

    private boolean isJSON(String s) {
        return s.trim().startsWith("{") || s.trim().startsWith("[");
    }
}

