/*
 * Decompiled with CFR 0.152.
 */
package restx.tests;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import restx.factory.Factory;
import restx.specs.RestxSpec;
import restx.specs.RestxSpecLoader;
import restx.tests.RestxSpecRule;

public class RestxSpecTests {
    private final RestxSpecRule rule;
    private final List<RestxSpec> specs;

    public static Iterable<Object[]> specsAsParametersIn(String location) throws IOException {
        return Collections2.transform(RestxSpecTests.findSpecsIn(location), (Function)new Function<RestxSpec, Object[]>(){

            public Object[] apply(RestxSpec restxSpec) {
                return new Object[]{restxSpec};
            }
        });
    }

    public static List<RestxSpec> findSpecsIn(String location) throws IOException {
        RestxSpecLoader loader = new RestxSpecLoader(Factory.getInstance());
        Set specResources = new ConfigurationBuilder().setUrls((Collection)ClasspathHelper.forPackage((String)location, (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new ResourcesScanner()}).filterInputsBy((Predicate)new FilterBuilder().includePackage(location.replace('/', '.'))).build().getResources(Pattern.compile(".*\\.spec\\.yaml"));
        ArrayList loaded = Lists.newArrayList();
        for (String specResource : specResources) {
            loaded.add(loader.load(specResource));
        }
        return loaded;
    }

    public RestxSpecTests(RestxSpecRule rule, List<RestxSpec> specs) {
        this.rule = rule;
        this.specs = specs;
    }

    public RestxSpecRule getRule() {
        return this.rule;
    }

    public List<RestxSpec> getSpecs() {
        return this.specs;
    }
}

