/*
 * Decompiled with CFR 0.152.
 */
package restx.specs;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import restx.AppSettings;
import restx.admin.AdminPage;
import restx.factory.BillOfMaterials;
import restx.factory.BoundlessComponentBox;
import restx.factory.ComponentBox;
import restx.factory.DefaultFactoryMachine;
import restx.factory.EmptyBox;
import restx.factory.Factory;
import restx.factory.Machine;
import restx.factory.MachineEngine;
import restx.factory.Name;
import restx.factory.NamedComponent;
import restx.factory.SatisfiedBOM;
import restx.security.PermissionFactory;
import restx.security.RestxSecurityManager;
import restx.specs.RestxSpec;
import restx.specs.RestxSpecRecorder;
import restx.specs.SpecRecorderRoute;

@Machine
public class SpecRecorderRouteFactoryMachine
extends DefaultFactoryMachine {
    public static final Name<SpecRecorderRoute> RECORDER_ROUTE_NAME = Name.of(SpecRecorderRoute.class, (String)"SpecRecorderRoute");
    private static final Factory.Query<AppSettings> appSettings = Factory.Query.byClass(AppSettings.class).mandatory();
    private static final Factory.Query<RestxSpecRecorder.Repository> recordedSpecRepo = Factory.Query.byClass(RestxSpecRecorder.Repository.class);
    private static final Factory.Query<RestxSpec.StorageSettings> storageSettings = Factory.Query.byClass(RestxSpec.StorageSettings.class).mandatory();
    private static final Factory.Query<RestxSecurityManager> securityManager = Factory.Query.byClass(RestxSecurityManager.class).mandatory();
    private static final Factory.Query<PermissionFactory> permissionFactory = Factory.Query.byClass(PermissionFactory.class).mandatory();
    private static final Name<AdminPage> ADMIN_PAGE_NAME = Name.of(AdminPage.class, (String)"Recorder");

    public SpecRecorderRouteFactoryMachine() {
        super(0, new MachineEngine[]{new MachineEngine<SpecRecorderRoute>(){

            public Name<SpecRecorderRoute> getName() {
                return RECORDER_ROUTE_NAME;
            }

            public int getPriority() {
                return 0;
            }

            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.of(recordedSpecRepo, storageSettings, securityManager, permissionFactory));
            }

            public ComponentBox<SpecRecorderRoute> newComponent(SatisfiedBOM satisfiedBOM) {
                Optional recorder = satisfiedBOM.getOne(recordedSpecRepo);
                if (!recorder.isPresent()) {
                    return new EmptyBox(RECORDER_ROUTE_NAME);
                }
                return BoundlessComponentBox.FACTORY.of(new NamedComponent(RECORDER_ROUTE_NAME, (Object)new SpecRecorderRoute((RestxSpecRecorder.Repository)((NamedComponent)recorder.get()).getComponent(), (RestxSpec.StorageSettings)satisfiedBOM.getOneAsComponent(storageSettings).get(), (RestxSecurityManager)satisfiedBOM.getOneAsComponent(securityManager).get(), (PermissionFactory)satisfiedBOM.getOneAsComponent(permissionFactory).get())));
            }

            public String toString() {
                return "SpecRecorderRouteFactoryMachineEngine";
            }
        }, new MachineEngine<AdminPage>(){

            public Name<AdminPage> getName() {
                return ADMIN_PAGE_NAME;
            }

            public int getPriority() {
                return 0;
            }

            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.of(appSettings));
            }

            public ComponentBox<AdminPage> newComponent(SatisfiedBOM satisfiedBOM) {
                AppSettings settings = (AppSettings)((NamedComponent)satisfiedBOM.getOne(appSettings).get()).getComponent();
                if (!"recording".equals(settings.mode())) {
                    return new EmptyBox(ADMIN_PAGE_NAME);
                }
                return BoundlessComponentBox.FACTORY.of(new NamedComponent(ADMIN_PAGE_NAME, (Object)new AdminPage("/@/ui/recorder/", "Recorder")));
            }
        }});
    }
}

