/*
 * Decompiled with CFR 0.152.
 */
package restx.monitor;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jvm.ThreadDump;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.util.Map;
import restx.annotations.GET;
import restx.annotations.RestxResource;
import restx.common.metrics.api.health.HealthCheckRegistry;
import restx.factory.Component;
import restx.metrics.codahale.CodahaleMetricRegistry;
import restx.metrics.codahale.health.CodahaleHealthCheckRegistry;
import restx.security.RolesAllowed;

@RestxResource(group="restx-admin")
@Component
public class MetricsResource {
    private final MetricRegistry metrics;
    private final com.codahale.metrics.health.HealthCheckRegistry healthChecks;
    private final ThreadDump threadDump;

    public MetricsResource(restx.common.metrics.api.MetricRegistry metricRegistry, HealthCheckRegistry healthCheckRegistry) {
        if (!(metricRegistry instanceof CodahaleMetricRegistry)) {
            throw new IllegalStateException("restx-monitor-admin expects that module restx-monitor-codahale is loaded");
        }
        CodahaleMetricRegistry codahaleMetricRegistry = (CodahaleMetricRegistry)metricRegistry;
        CodahaleHealthCheckRegistry codahaleHealthCheckRegistry = (CodahaleHealthCheckRegistry)healthCheckRegistry;
        this.metrics = codahaleMetricRegistry.getCodahaleMetricRegistry();
        this.healthChecks = codahaleHealthCheckRegistry.getCodahaleHealthCheckRegistry();
        this.threadDump = new ThreadDump(ManagementFactory.getThreadMXBean());
    }

    @RolesAllowed(value={"restx-admin"})
    @GET(value="/@/metrics")
    public Map metrics() {
        return ImmutableMap.of((Object)"gauges", (Object)this.metrics.getGauges(), (Object)"timers", (Object)this.metrics.getTimers(), (Object)"meters", (Object)this.metrics.getMeters(), (Object)"counters", (Object)this.metrics.getCounters(), (Object)"histograms", (Object)this.metrics.getHistograms());
    }

    @RolesAllowed(value={"restx-admin"})
    @GET(value="/@/health-checks")
    public Map healthChecks() {
        return this.healthChecks.runHealthChecks();
    }

    @RolesAllowed(value={"restx-admin"})
    @GET(value="/@/thread-dump")
    public String threadDump() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.threadDump.dump((OutputStream)out);
        return new String(out.toByteArray());
    }
}

