/*
 * Decompiled with CFR 0.152.
 */
package restx.validation;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Path;

public class MethodArgumentNotValidException
extends IllegalArgumentException {
    public static Function<ConstraintViolation, ViolationContent> VIOLATION_CONTENT_EXTRACTOR = new Function<ConstraintViolation, ViolationContent>(){

        public ViolationContent apply(ConstraintViolation input) {
            return new ViolationContent(input.getMessage(), input.getPropertyPath(), input.getRootBeanClass());
        }
    };
    private final Set<ViolationContent> violations;

    public <T> MethodArgumentNotValidException(Set<ConstraintViolation<T>> violations) {
        super(Joiner.on((String)", ").join(violations));
        this.violations = Sets.newHashSet((Iterable)Collections2.transform(violations, VIOLATION_CONTENT_EXTRACTOR));
    }

    public Set<ViolationContent> getViolations() {
        return this.violations;
    }

    public static class ViolationContent {
        private final String message;
        private final Path propertyPath;
        private final Class rootBeanClass;

        public ViolationContent(String message, Path propertyPath, Class rootBeanClass) {
            this.message = message;
            this.propertyPath = propertyPath;
            this.rootBeanClass = rootBeanClass;
        }

        public String getMessage() {
            return this.message;
        }

        public Path getPropertyPath() {
            return this.propertyPath;
        }

        public Class getRootBeanClass() {
            return this.rootBeanClass;
        }
    }
}

