/*
 * Decompiled with CFR 0.152.
 */
package restx.specs;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import restx.common.MorePreconditions;
import restx.common.MoreResources;
import restx.factory.Component;
import restx.factory.Factory;
import restx.factory.NamedComponent;
import restx.http.HttpStatus;
import restx.specs.Given;
import restx.specs.RestxSpec;
import restx.specs.ThenHttpResponse;
import restx.specs.WhenHttpRequest;

@Component
public class RestxSpecLoader {
    private static final Logger logger = LoggerFactory.getLogger(RestxSpecLoader.class);
    private final Set<NamedComponent<GivenLoader>> givenLoaders;
    private final Set<NamedComponent<WhenHeaderLoader>> whenHeaderLoaders;
    private final String names;

    @Inject
    public RestxSpecLoader(Factory factory) {
        this(factory.queryByClass(GivenLoader.class).find(), factory.queryByClass(WhenHeaderLoader.class).find());
    }

    public RestxSpecLoader(Set<NamedComponent<GivenLoader>> givenLoaders, Set<NamedComponent<WhenHeaderLoader>> whenHeaderLoaders) {
        this.givenLoaders = givenLoaders;
        this.whenHeaderLoaders = whenHeaderLoaders;
        ArrayList names = Lists.newArrayList();
        for (NamedComponent<GivenLoader> givenLoader : givenLoaders) {
            names.add(givenLoader.getName().getName());
        }
        this.names = Joiner.on((String)", ").join((Iterable)names);
    }

    public RestxSpec load(String resource) throws IOException {
        return this.load(resource, Resources.asCharSource((URL)MoreResources.getResource((String)resource, (boolean)true), (Charset)Charsets.UTF_8));
    }

    public RestxSpec load(String path, CharSource charSource) throws IOException {
        Yaml yaml = new Yaml();
        Map spec = (Map)yaml.load(charSource.read());
        List<Given> givens = this.loadGivens(spec);
        ArrayList whens = Lists.newArrayList();
        Iterable wts = (Iterable)MorePreconditions.checkInstanceOf((String)"wts", spec.get("wts"), Iterable.class);
        for (Object wt : wts) {
            Matcher methodAndPathMatcher;
            String body;
            String definition;
            Map whenThen = (Map)MorePreconditions.checkInstanceOf((String)"when/then", wt, Map.class);
            Object w = whenThen.get("when");
            if (!(w instanceof String)) continue;
            WhenHttpRequest.Builder whenHttpBuilder = WhenHttpRequest.builder();
            String ws = (String)w;
            int nlIndex = ws.indexOf("\n");
            if (nlIndex != -1) {
                definition = ws.substring(0, nlIndex);
                body = ws.substring(nlIndex + 1).trim();
                Optional<WhenHeaderLoader> whenHeader = this.resolveFromBody(body);
                while (whenHeader.isPresent()) {
                    String headerValue;
                    nlIndex = body.indexOf("\n");
                    if (nlIndex == -1) {
                        headerValue = body.substring(((WhenHeaderLoader)whenHeader.get()).detectionPattern().length(), body.length());
                        body = "";
                    } else {
                        headerValue = body.substring(((WhenHeaderLoader)whenHeader.get()).detectionPattern().length(), nlIndex);
                        body = body.substring(nlIndex + 1).trim();
                    }
                    ((WhenHeaderLoader)whenHeader.get()).loadHeader(headerValue, whenHttpBuilder);
                    whenHeader = this.resolveFromBody(body);
                }
            } else {
                definition = ws;
                body = "";
            }
            if ((methodAndPathMatcher = Pattern.compile("(GET|POST|PUT|DELETE|HEAD|OPTIONS) (.+)").matcher(definition)).matches()) {
                String then = ((String)MorePreconditions.checkInstanceOf((String)"then", whenThen.get("then"), String.class)).trim();
                HttpStatus code = HttpStatus.OK;
                int endLineIndex = then.indexOf("\n");
                if (endLineIndex == -1) {
                    endLineIndex = then.length();
                }
                String firstLine = then.substring(0, endLineIndex);
                Matcher respMatcher = Pattern.compile("^(\\d{3}).*$").matcher(firstLine);
                if (respMatcher.matches()) {
                    code = HttpStatus.havingCode(Integer.parseInt(respMatcher.group(1)));
                    then = then.substring(endLineIndex).trim();
                }
                whens.add(whenHttpBuilder.withMethod(methodAndPathMatcher.group(1)).withPath(methodAndPathMatcher.group(2)).withBody(body).withThen(new ThenHttpResponse(code.getCode(), then)).build());
                continue;
            }
            throw new IllegalArgumentException("unrecognized 'when' format: it must begin with a HTTP declaration of the form 'VERB resource/path'\nEg: GET users/johndoe\n. Was: '" + ws + "'\n");
        }
        return new RestxSpec(path, (String)MorePreconditions.checkInstanceOf((String)"title", spec.get("title"), String.class), (ImmutableList<? extends Given>)ImmutableList.copyOf(givens), ImmutableList.copyOf((Collection)whens));
    }

    private Optional<WhenHeaderLoader> resolveFromBody(String body) {
        for (NamedComponent<WhenHeaderLoader> whenHeaderLoader : this.whenHeaderLoaders) {
            if (!body.startsWith(((WhenHeaderLoader)whenHeaderLoader.getComponent()).detectionPattern())) continue;
            return Optional.of((Object)((WhenHeaderLoader)whenHeaderLoader.getComponent()));
        }
        return Optional.absent();
    }

    private List<Given> loadGivens(Map testCase) throws IOException {
        ArrayList givens = Lists.newArrayList();
        Iterable given = (Iterable)MorePreconditions.checkInstanceOf((String)"given", testCase.get("given"), Iterable.class);
        for (Object g : given) {
            Map given1 = (Map)MorePreconditions.checkInstanceOf((String)"given", g, Map.class);
            if (given1.isEmpty()) {
                throw new IllegalArgumentException(String.format("can't load %s: a given has no properties at all", testCase));
            }
            String firstKey = (String)MorePreconditions.checkInstanceOf((String)"key", given1.keySet().iterator().next(), String.class);
            givens.add(this.findLoader(given1, firstKey).load(given1));
        }
        return givens;
    }

    private GivenLoader findLoader(Map given, String type) {
        for (NamedComponent<GivenLoader> givenLoader : this.givenLoaders) {
            if (!givenLoader.getName().getName().equalsIgnoreCase(type)) continue;
            return (GivenLoader)givenLoader.getComponent();
        }
        throw new IllegalArgumentException("invalid given " + given + ": unrecognized type " + type + ". Was expecting one of [" + this.names + "] as either first field or 'type' property");
    }

    public static interface GivenLoader {
        public Given load(Map<String, ?> var1);
    }

    public static interface WhenHeaderLoader {
        public String detectionPattern();

        public void loadHeader(String var1, WhenHttpRequest.Builder var2);
    }
}

