/*
 * Decompiled with CFR 0.152.
 */
package restx.specs;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import restx.common.RestxConfig;
import restx.config.SettingsKey;
import restx.factory.Component;
import restx.specs.Given;
import restx.specs.When;

public class RestxSpec {
    private final String path;
    private final String title;
    private final ImmutableList<? extends Given> given;
    private final ImmutableList<? extends When<?>> whens;

    public RestxSpec(String path, String title, ImmutableList<? extends Given> given, ImmutableList<? extends When<?>> whens) {
        this.path = (String)Preconditions.checkNotNull((Object)path);
        this.title = (String)Preconditions.checkNotNull((Object)title);
        this.given = given;
        this.whens = whens;
    }

    public void store(File destFile) throws IOException {
        destFile.getParentFile().mkdirs();
        Files.write((CharSequence)this.toString(), (File)destFile, (Charset)Charsets.UTF_8);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("title: ").append(this.title).append("\n");
        if (!this.given.isEmpty()) {
            sb.append("given:\n");
            for (Given g : this.given) {
                g.toString(sb);
            }
        }
        sb.append("wts:\n");
        for (When when : this.whens) {
            when.toString(sb);
        }
        return sb.toString();
    }

    public String getPath() {
        return this.path;
    }

    public String getTitle() {
        return this.title;
    }

    public RestxSpec withTitle(String title) {
        return new RestxSpec(this.path, title, this.given, this.whens);
    }

    public RestxSpec withTitle(Optional<String> title) {
        if (title.isPresent()) {
            return this.withTitle((String)title.get());
        }
        return this;
    }

    public RestxSpec withPath(String path) {
        return new RestxSpec(path, this.title, this.given, this.whens);
    }

    public RestxSpec withPath(Optional<String> path) {
        if (path.isPresent()) {
            return this.withPath((String)path.get());
        }
        return this;
    }

    public RestxSpec withWhens(ImmutableList<When<?>> whens) {
        return new RestxSpec(this.path, this.title, this.given, whens);
    }

    public RestxSpec withWhenAt(int index, When when) {
        ArrayList whens = new ArrayList((Collection<When<?>>)this.getWhens());
        whens.set(index, when);
        return this.withWhens(ImmutableList.copyOf(whens));
    }

    public ImmutableList<? extends Given> getGiven() {
        return this.given;
    }

    public ImmutableList<? extends When<?>> getWhens() {
        return this.whens;
    }

    public static class Storage {
        private final StorageSettings settings;
        private static final Pattern WINDOWS_PATH_PATTERN = Pattern.compile("^[A-Z]:\\\\.*");

        public static Storage with(StorageSettings settings) {
            return new Storage(settings);
        }

        private Storage(StorageSettings settings) {
            this.settings = settings;
        }

        public File getStoreFile(String path) {
            if (Storage.pathLooksAbsolute(path)) {
                return new File(path);
            }
            String basePath = this.settings.recorderBasePath();
            return new File(basePath + "/" + path);
        }

        private static boolean pathLooksAbsolute(String path) {
            return path.startsWith("/") || WINDOWS_PATH_PATTERN.matcher(path).matches();
        }

        public File store(RestxSpec spec) throws IOException {
            File storeFile = this.getStoreFile(spec.getPath());
            spec.store(storeFile);
            return storeFile;
        }

        public String buildPath(Optional<String> dir, String title) {
            return (String)dir.or((Object)this.settings.recorderBaseSpecPath()) + "/" + title.replace(' ', '_').replace('/', '_') + ".spec.yaml";
        }
    }

    public static interface StorageSettings {
        @SettingsKey(key="restx.recorder.basePath", defaultValue="src/main/resources")
        public String recorderBasePath();

        @SettingsKey(key="restx.recorder.baseSpecPath", defaultValue="specs")
        public String recorderBaseSpecPath();
    }

    @Component
    public static class StorageSettingsConfig
    implements StorageSettings {
        private final RestxConfig config;

        public StorageSettingsConfig(RestxConfig config) {
            this.config = config;
        }

        @Override
        public String recorderBasePath() {
            return (String)this.config.getString("restx.recorder.basePath").get();
        }

        @Override
        public String recorderBaseSpecPath() {
            return (String)this.config.getString("restx.recorder.baseSpecPath").get();
        }
    }
}

