/*
 * Decompiled with CFR 0.152.
 */
package restx.server;

import com.google.common.base.Optional;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import restx.server.WebServer;

public class WebServers {
    private static final ConcurrentMap<String, WebServer> servers = new ConcurrentHashMap<String, WebServer>();

    public static void register(WebServer server) {
        servers.putIfAbsent(server.getServerId(), server);
    }

    public static void unregister(String serverId) {
        servers.remove(serverId);
    }

    public static Optional<WebServer> getServerById(String serverId) {
        return Optional.fromNullable((Object)((WebServer)servers.get(serverId)));
    }

    public static int findAvailablePort() throws IOException {
        try (ServerSocket s = new ServerSocket(0);){
            int n = s.getLocalPort();
            return n;
        }
    }

    public static String baseUri(String bindInterface, int port) {
        if (bindInterface == null || bindInterface.equals("0.0.0.0")) {
            try {
                InetAddress ip = InetAddress.getLocalHost();
                bindInterface = ip.getHostAddress();
            }
            catch (UnknownHostException e) {
                bindInterface = "localhost";
            }
        }
        return String.format("http://%s:%s", bindInterface, port);
    }

    public static String baseUri(String bindInterface, int port, String routerPath) {
        return WebServers.baseUri(bindInterface, port) + routerPath;
    }
}

