/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import restx.common.RestxConfig;
import restx.factory.BillOfMaterials;
import restx.factory.BoundlessComponentBox;
import restx.factory.DefaultFactoryMachine;
import restx.factory.Factory;
import restx.factory.Machine;
import restx.factory.MachineEngine;
import restx.factory.Name;
import restx.factory.NamedComponent;
import restx.factory.SatisfiedBOM;
import restx.factory.StdMachineEngine;
import restx.security.RestxSessionCookieDescriptor;
import restx.security.SecurityFactory;

@Machine
public class SecurityFactoryFactoryMachine
extends DefaultFactoryMachine {
    private static final SecurityFactory module = new SecurityFactory();

    public SecurityFactoryFactoryMachine() {
        super(1000, new MachineEngine[]{new StdMachineEngine<RestxSessionCookieDescriptor>(Name.of(RestxSessionCookieDescriptor.class, (String)"restxSessionCookieDescriptor"), 1000, BoundlessComponentBox.FACTORY){
            private final Factory.Query<String> appName = Factory.Query.byName((Name)Name.of(String.class, (String)"app.name")).optional();
            private final Factory.Query<RestxConfig> restxConfig = Factory.Query.byClass(RestxConfig.class).mandatory();

            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.of(this.appName, this.restxConfig));
            }

            public RestxSessionCookieDescriptor doNewComponent(SatisfiedBOM satisfiedBOM) {
                return module.restxSessionCookieDescriptor((Optional<String>)satisfiedBOM.getOneAsComponent(this.appName), (RestxConfig)((NamedComponent)satisfiedBOM.getOne(this.restxConfig).get()).getComponent());
            }
        }});
    }
}

