/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import restx.factory.BillOfMaterials;
import restx.factory.BoundlessComponentBox;
import restx.factory.Factory;
import restx.factory.Machine;
import restx.factory.MachineEngine;
import restx.factory.Name;
import restx.factory.NamedComponent;
import restx.factory.SatisfiedBOM;
import restx.factory.SingleNameFactoryMachine;
import restx.factory.StdMachineEngine;
import restx.security.PermissionFactory;
import restx.security.RestxSession;
import restx.security.RestxSessionCookieDescriptor;
import restx.security.RestxSessionCookieFilter;
import restx.security.Signer;

@Machine
public class RestxSessionCookieFilterFactoryMachine
extends SingleNameFactoryMachine<RestxSessionCookieFilter> {
    public static final Name<RestxSessionCookieFilter> NAME = Name.of(RestxSessionCookieFilter.class, (String)"RestxSessionCookieFilter");

    public RestxSessionCookieFilterFactoryMachine() {
        super(-200, (MachineEngine)new StdMachineEngine<RestxSessionCookieFilter>(NAME, -200, BoundlessComponentBox.FACTORY){
            private final Factory.Query<RestxSession.Definition> sessionDefinition = Factory.Query.byClass(RestxSession.Definition.class).mandatory();
            private final Factory.Query<ObjectMapper> mapper = Factory.Query.byName((Name)Name.of(ObjectMapper.class, (String)"FrontObjectMapper")).mandatory();
            private final Factory.Query<Signer> signer = Factory.Query.byName((Name)Name.of(Signer.class, (String)"CookieSigner")).mandatory();
            private final Factory.Query<PermissionFactory> permissionFactory = Factory.Query.byClass(PermissionFactory.class).mandatory();
            private final Factory.Query<RestxSessionCookieDescriptor> restxSessionCookieDescriptor = Factory.Query.byClass(RestxSessionCookieDescriptor.class).mandatory();

            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.of(this.sessionDefinition, this.mapper, this.signer, this.permissionFactory, this.restxSessionCookieDescriptor));
            }

            protected RestxSessionCookieFilter doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new RestxSessionCookieFilter((RestxSession.Definition)((NamedComponent)satisfiedBOM.getOne(this.sessionDefinition).get()).getComponent(), (ObjectMapper)((NamedComponent)satisfiedBOM.getOne(this.mapper).get()).getComponent(), (Signer)((NamedComponent)satisfiedBOM.getOne(this.signer).get()).getComponent(), (PermissionFactory)((NamedComponent)satisfiedBOM.getOne(this.permissionFactory).get()).getComponent(), (RestxSessionCookieDescriptor)((NamedComponent)satisfiedBOM.getOne(this.restxSessionCookieDescriptor).get()).getComponent());
            }
        });
    }
}

