/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.chrylis.codec.base58.Base58Codec;
import com.google.common.base.Optional;
import restx.http.HTTP;

public class RestxSessionCookieDescriptor {
    private String cookieName;
    private String cookieSignatureName;
    private String domain;
    private Boolean secure;
    private Boolean encode;

    public RestxSessionCookieDescriptor(String cookieName, String cookieSignatureName, Boolean encode) {
        this(cookieName, cookieSignatureName, (Optional<String>)Optional.absent(), (Optional<Boolean>)Optional.absent(), encode);
    }

    public RestxSessionCookieDescriptor(String cookieName, String cookieSignatureName, Optional<String> domain, Optional<Boolean> secure, Boolean encode) {
        this.cookieName = HTTP.headerTokenCompatible(cookieName, "_");
        this.cookieSignatureName = HTTP.headerTokenCompatible(cookieSignatureName, "_");
        this.domain = (String)domain.orNull();
        this.secure = (Boolean)secure.orNull();
        this.encode = encode;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public String getCookieSignatureName() {
        return this.cookieSignatureName;
    }

    public Optional<String> getDomain() {
        return Optional.fromNullable((Object)this.domain);
    }

    public Optional<Boolean> getSecure() {
        return Optional.fromNullable((Object)this.secure);
    }

    public Boolean getEncode() {
        return this.encode;
    }

    public String encodeValueIfNeeded(String value) {
        return this.encode != false && value != null ? Base58Codec.doEncode((byte[])value.getBytes()) : value;
    }

    public String decodeValueIfNeeded(String value) {
        return this.encode != false && value != null ? new String(Base58Codec.doDecode((String)value)) : value;
    }
}

