/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.google.common.base.Optional;
import javax.inject.Named;
import restx.common.Crypto;
import restx.factory.Component;
import restx.security.SignatureKey;
import restx.security.Signer;

@Named(value="CookieSigner")
@Component
public class DefaultCookieSigner
implements Signer {
    private final SignatureKey signatureKey;

    public DefaultCookieSigner(Optional<SignatureKey> signatureKey) {
        this.signatureKey = (SignatureKey)signatureKey.or((Object)SignatureKey.DEFAULT);
    }

    @Override
    public String sign(String cookie) {
        return Crypto.sign((String)cookie, (byte[])this.signatureKey.getKey());
    }

    @Override
    public boolean verify(String cookie, String signedCookie) {
        return this.sign(cookie).equals(signedCookie);
    }
}

