/*
 * Decompiled with CFR 0.152.
 */
package restx.security;

import com.google.common.collect.ImmutableSet;
import restx.factory.BillOfMaterials;
import restx.factory.BoundlessComponentBox;
import restx.factory.Factory;
import restx.factory.Machine;
import restx.factory.MachineEngine;
import restx.factory.Name;
import restx.factory.SatisfiedBOM;
import restx.factory.SingleNameFactoryMachine;
import restx.factory.StdMachineEngine;
import restx.security.CORSAuthorizer;
import restx.security.CORSRoute;

@Machine
public class CORSRouteFactoryMachine
extends SingleNameFactoryMachine<CORSRoute> {
    public static final Name<CORSRoute> NAME = Name.of(CORSRoute.class, (String)"CORSRoute");

    public CORSRouteFactoryMachine() {
        super(0, (MachineEngine)new StdMachineEngine<CORSRoute>(NAME, 0, BoundlessComponentBox.FACTORY){
            private final Factory.Query<CORSAuthorizer> authorizers = Factory.Query.byClass(CORSAuthorizer.class).optional();

            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.of(this.authorizers));
            }

            protected CORSRoute doNewComponent(SatisfiedBOM satisfiedBOM) {
                return new CORSRoute(satisfiedBOM.getAsComponents(this.authorizers));
            }
        });
    }
}

