/*
 * Decompiled with CFR 0.152.
 */
package restx.jackson;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import restx.RestxContext;
import restx.RestxRequest;
import restx.entity.EntityRequestBodyReader;

public class JsonEntityRequestBodyReader<T>
implements EntityRequestBodyReader<T> {
    private final Type type;
    protected final ObjectReader reader;

    public static <T> JsonEntityRequestBodyReader<T> using(Type type, ObjectReader reader) {
        return new JsonEntityRequestBodyReader<T>(type, reader);
    }

    private JsonEntityRequestBodyReader(Type type, ObjectReader reader) {
        this.type = type;
        this.reader = reader;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public T readBody(RestxRequest req, RestxContext ctx) throws IOException {
        return JsonEntityRequestBodyReader.readNullableValue(this.reader, req.getContentStream());
    }

    protected static <T> T readNullableValue(ObjectReader reader, InputStream stream) throws IOException {
        try {
            return (T)reader.readValue(stream);
        }
        catch (JsonMappingException e) {
            if (e.getMessage().startsWith("No content to map due to end-of-input")) {
                return null;
            }
            throw Throwables.propagate((Throwable)e);
        }
    }
}

