/*
 * Decompiled with CFR 0.152.
 */
package restx.jackson;

import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.base.Optional;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Locale;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.entity.EntityDefaultContentTypeProvider;
import restx.entity.EntityRequestBodyReader;
import restx.entity.EntityRequestBodyReaderFactory;
import restx.entity.EntityResponseWriter;
import restx.entity.EntityResponseWriterFactory;
import restx.factory.Module;
import restx.factory.Provides;
import restx.jackson.JsonEntityRequestBodyReader;
import restx.jackson.JsonEntityResponseWriter;
import restx.jackson.Views;

@Module(priority=1000)
public class JsonContentTypeModule {
    private static final Logger logger = LoggerFactory.getLogger(JsonContentTypeModule.class);
    private static final String JACKSON_VIEW_PARAMETER = "view=";

    @Provides
    public EntityDefaultContentTypeProvider jsonEntityDefaultContentTypeProvider() {
        return new EntityDefaultContentTypeProvider(){

            @Override
            public Optional<String> mayProvideDefaultContentType(Type type) {
                return Optional.of((Object)"application/json");
            }
        };
    }

    @Provides
    public EntityRequestBodyReaderFactory jsonEntityRequestBodyReaderFactory(final @Named(value="FrontObjectReader") ObjectReader reader) {
        return new EntityRequestBodyReaderFactory(){

            @Override
            public <T> Optional<? extends EntityRequestBodyReader<T>> mayBuildFor(Type valueType, String contentType) {
                if (!contentType.toLowerCase(Locale.ENGLISH).startsWith("application/json")) {
                    return Optional.absent();
                }
                Class<?> clazz = JsonContentTypeModule.this.getCTJacksonViewClass(valueType, contentType, Views.Transient.class);
                return Optional.of(JsonEntityRequestBodyReader.using(valueType, reader.withView(clazz).withType(TypeFactory.defaultInstance().constructType(valueType))));
            }
        };
    }

    @Provides
    public EntityResponseWriterFactory jsonEntityResponseWriterFactory(final @Named(value="FrontObjectWriter") ObjectWriter objectWriter) {
        return new EntityResponseWriterFactory(){

            @Override
            public <T> Optional<? extends EntityResponseWriter<T>> mayBuildFor(Type valueType, String contentType) {
                if (!contentType.toLowerCase(Locale.ENGLISH).startsWith("application/json")) {
                    return Optional.absent();
                }
                Class<?> clazz = JsonContentTypeModule.this.getCTJacksonViewClass(valueType, contentType, Views.Transient.class);
                ObjectWriter writer = objectWriter.withView(clazz);
                if (valueType instanceof ParameterizedType) {
                    writer = writer.withType(TypeFactory.defaultInstance().constructType(valueType));
                }
                return Optional.of(JsonEntityResponseWriter.using(valueType, writer));
            }
        };
    }

    private Class<?> getCTJacksonViewClass(Type valueType, String contentType, Class<?> defaultClazz) {
        int parameterIndex = contentType.indexOf(JACKSON_VIEW_PARAMETER);
        if (parameterIndex != -1) {
            String className = contentType.substring(parameterIndex + JACKSON_VIEW_PARAMETER.length());
            try {
                return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                logger.error("The Jackson view class '{}' was not found while marshalling type '{}' (content-type : '{}')", new Object[]{className, valueType, contentType});
                throw new IllegalStateException(e);
            }
        }
        return defaultClazz;
    }
}

