/*
 * Decompiled with CFR 0.152.
 */
package restx.http;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.ExecutionException;
import restx.RestxRequest;
import restx.RestxResponse;
import restx.StdRoute;
import restx.annotations.LocationHeader;
import restx.common.Mustaches;
import restx.description.OperationDescription;
import restx.description.ResourceDescription;
import restx.factory.Component;
import restx.http.EntityRelatedFilter;

@Component
public class LocationHeaderFilter
extends EntityRelatedFilter {
    private LoadingCache<String, Template> templatesCache = CacheBuilder.newBuilder().maximumSize(200L).build((CacheLoader)new CacheLoader<String, Template>(){

        public Template load(String template) throws Exception {
            return Mustaches.compileTemplateWithSingleBrackets((String)template);
        }
    });

    public LocationHeaderFilter() {
        super((Predicate<StdRoute>)Predicates.alwaysTrue(), (Predicate<ResourceDescription>)Predicates.alwaysTrue(), new OperationDescription.Matcher().havingAnyAnnotations(LocationHeader.class));
    }

    @Override
    protected void onEntityOutput(StdRoute stdRoute, RestxRequest req, RestxResponse resp, Optional<?> input, Optional<?> output, ResourceDescription resourceDescription, OperationDescription operationDescription) {
        if (!output.isPresent()) {
            return;
        }
        LocationHeader locationHeaderAnn = (LocationHeader)operationDescription.findAnnotation(LocationHeader.class).get();
        try {
            StringWriter locationWriter = new StringWriter();
            ((Template)this.templatesCache.get((Object)locationHeaderAnn.value())).execute(output.get(), (Object)ImmutableMap.of((Object)"_baseUri_", (Object)req.getBaseUri(), (Object)"_currentUri_", (Object)(req.getBaseUri() + req.getRestxUri())), (Writer)locationWriter);
            resp.setHeader("Location", locationWriter.toString());
        }
        catch (ExecutionException e) {
            Throwables.propagate((Throwable)e);
        }
    }
}

