/*
 * Decompiled with CFR 0.152.
 */
package restx.http;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import restx.HttpSettings;
import restx.RestxContext;
import restx.RestxFilter;
import restx.RestxHandler;
import restx.RestxHandlerMatch;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxRequestMatcher;
import restx.RestxResponse;
import restx.RestxResponseWrapper;
import restx.StdRestxRequestMatcher;

public class GzipFilter
implements RestxFilter,
RestxHandler {
    private final ImmutableCollection<RestxRequestMatcher> matchers;

    public GzipFilter(HttpSettings httpSettings) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String path : httpSettings.gzipPaths()) {
            builder.add((Object)new StdRestxRequestMatcher("GET", path));
        }
        this.matchers = builder.build();
    }

    @Override
    public Optional<RestxHandlerMatch> match(RestxRequest request) {
        Optional<String> enc = request.getHeader("Accept-Encoding");
        if (!enc.isPresent()) {
            return Optional.absent();
        }
        if (!this.acceptsGzip((String)enc.get())) {
            return Optional.absent();
        }
        for (RestxRequestMatcher matcher : this.matchers) {
            Optional<? extends RestxRequestMatch> match = matcher.match(request.getHttpMethod(), request.getRestxPath());
            if (!match.isPresent()) continue;
            return Optional.of((Object)new RestxHandlerMatch((RestxRequestMatch)match.get(), this));
        }
        return Optional.absent();
    }

    protected boolean acceptsGzip(String acceptsEncoding) {
        if ("*".equals(acceptsEncoding)) {
            return true;
        }
        for (String s : acceptsEncoding.split(",")) {
            if (!s.trim().startsWith("gzip")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void handle(RestxRequestMatch restxRequestMatch, RestxRequest restxRequest, RestxResponse restxResponse, RestxContext restxContext) throws IOException {
        restxContext.nextHandlerMatch().handle(restxRequest, new RestxResponseWrapper(restxResponse){
            private GZIPOutputStream gzipOutputStream;

            @Override
            public OutputStream getOutputStream() throws IOException {
                this.setHeader("Content-Encoding", "gzip");
                this.gzipOutputStream = new GZIPOutputStream(super.getOutputStream());
                return this.gzipOutputStream;
            }

            @Override
            public void close() throws Exception {
                if (this.gzipOutputStream != null) {
                    try {
                        this.gzipOutputStream.close();
                    }
                    finally {
                        this.gzipOutputStream = null;
                    }
                }
                super.close();
            }
        }, restxContext);
    }
}

