/*
 * Decompiled with CFR 0.152.
 */
package restx.http;

import com.google.common.base.Optional;
import restx.RestxRequest;
import restx.RestxResponse;
import restx.WebException;
import restx.http.CacheControl;
import restx.http.HttpStatus;

public class ETag {
    private final String value;
    private final CacheControl cacheControl;

    public ETag(String value, CacheControl cacheControl) {
        this.value = value;
        this.cacheControl = cacheControl;
    }

    public CacheControl getCacheControl() {
        return this.cacheControl;
    }

    public String getValue() {
        return this.value;
    }

    public void handleIn(RestxRequest req, RestxResponse resp) {
        if (req.getHeader("If-None-Match").equals((Object)Optional.of((Object)this.value))) {
            throw new WebException(HttpStatus.NOT_MODIFIED);
        }
        this.cacheControl.writeTo(resp);
        resp.setHeader("ETag", this.value);
    }

    public String toString() {
        return "ETag{value='" + this.value + "', cacheControl=" + this.cacheControl + "}";
    }
}

