/*
 * Decompiled with CFR 0.152.
 */
package restx.http;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import restx.RestxResponse;

public class CacheControl {
    public static final CacheControl MUST_REVALIDATE = new CacheControl(-1, (ImmutableList<String>)ImmutableList.of((Object)"must-revalidate"));
    private final int expires;
    private final ImmutableList<String> cacheControl;

    public CacheControl(int expires, ImmutableList<String> cacheControl) {
        this.expires = expires;
        this.cacheControl = cacheControl;
    }

    public int getExpires() {
        return this.expires;
    }

    public ImmutableList<String> getCacheControl() {
        return this.cacheControl;
    }

    public String toString() {
        return "CacheControl{expires=" + this.expires + ", cacheControl=" + this.cacheControl + "}";
    }

    public void writeTo(RestxResponse resp) {
        resp.setHeader("Expires", String.valueOf(this.expires));
        resp.setHeader("Cache-Control", Joiner.on((String)", ").join(this.cacheControl));
    }
}

