/*
 * Decompiled with CFR 0.152.
 */
package restx.exceptions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import restx.http.HttpStatus;

public class RestxError<T> {
    private final String id;
    private final HttpStatus errorStatus;
    private final String error;
    private final String description;
    private final Map<String, String> data = Maps.newLinkedHashMap();

    RestxError(String id, HttpStatus errorStatus, String error, String description) {
        this.id = id;
        this.errorStatus = errorStatus;
        this.error = error;
        this.description = description;
    }

    public RestxError<T> set(T field, String value) {
        if (value != null) {
            this.data.put(field.toString(), value);
        }
        return this;
    }

    public RestxException raise() {
        return new RestxException(this.id, DateTime.now().toDateTime(DateTimeZone.UTC), this.errorStatus, this.error, this.description, (ImmutableMap<String, String>)ImmutableMap.copyOf(this.data));
    }

    public static class RestxException
    extends RuntimeException {
        private final String id;
        private final DateTime errorTime;
        private final HttpStatus errorStatus;
        private final String error;
        private final String description;
        private final ImmutableMap<String, String> data;

        RestxException(String id, DateTime errorTime, HttpStatus errorStatus, String error, String description, ImmutableMap<String, String> data) {
            super(String.format("[%s] [%s] [%3d~%s] %s - %s", errorTime, id, errorStatus.getCode(), error, description, data));
            this.id = id;
            this.errorTime = errorTime;
            this.errorStatus = errorStatus;
            this.error = error;
            this.description = description;
            this.data = data;
        }

        public String getId() {
            return this.id;
        }

        public DateTime getErrorTime() {
            return this.errorTime;
        }

        public HttpStatus getErrorStatus() {
            return this.errorStatus;
        }

        public String getError() {
            return this.error;
        }

        public String getDescription() {
            return this.description;
        }

        public ImmutableMap<String, String> getData() {
            return this.data;
        }

        public String toJSON() {
            StringBuilder sb = new StringBuilder().append("{").append("\"id\": \"").append(this.id).append("\",").append("\"errorTime\": \"").append(this.errorTime).append("\",").append("\"errorCode\": \"").append(this.error).append("\",").append("\"description\": \"").append(this.description.replace("\"", "\\\"")).append("\",");
            sb.append("\"data\": {");
            if (!this.data.isEmpty()) {
                for (Map.Entry entry : this.data.entrySet()) {
                    sb.append("\"" + (String)entry.getKey() + "\": \"").append(((String)entry.getValue()).replace("\"", "\\\"")).append("\",");
                }
                sb.setLength(sb.length() - 1);
            }
            sb.append("}");
            sb.append("}");
            return sb.toString();
        }
    }
}

