/*
 * Decompiled with CFR 0.152.
 */
package restx.entity;

import com.google.common.base.Optional;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import restx.RestxContext;
import restx.RestxRequest;
import restx.RestxResponse;
import restx.entity.Empty;
import restx.entity.EntityDefaultContentTypeProvider;
import restx.entity.EntityRequestBodyReader;
import restx.entity.EntityRequestBodyReaderFactory;
import restx.entity.EntityResponseWriter;
import restx.entity.EntityResponseWriterFactory;
import restx.factory.Module;
import restx.factory.Provides;
import restx.http.HttpStatus;

@Module
public class VoidContentTypeModule {
    private static final Collection TYPES = Arrays.asList(Void.class, Void.TYPE, Empty.class);

    @Provides
    public EntityDefaultContentTypeProvider voidEntityDefaultContentTypeProvider() {
        return new EntityDefaultContentTypeProvider(){

            @Override
            public Optional<String> mayProvideDefaultContentType(Type type) {
                if (TYPES.contains(type)) {
                    return Optional.of((Object)"void");
                }
                return Optional.absent();
            }
        };
    }

    @Provides
    public EntityRequestBodyReaderFactory voidEntityRequestBodyReaderFactory() {
        return new EntityRequestBodyReaderFactory(){

            @Override
            public <T> Optional<? extends EntityRequestBodyReader<T>> mayBuildFor(Type valueType, String contentType) {
                if (!contentType.toLowerCase(Locale.ENGLISH).equals("void")) {
                    return Optional.absent();
                }
                return Optional.of((Object)VoidEntityRequestBodyReader.INSTANCE);
            }
        };
    }

    @Provides
    public EntityResponseWriterFactory voidEntityResponseWriterFactory() {
        return new EntityResponseWriterFactory(){

            @Override
            public <T> Optional<? extends EntityResponseWriter<T>> mayBuildFor(Type valueType, String contentType) {
                if (!contentType.toLowerCase(Locale.ENGLISH).equals("void")) {
                    return Optional.absent();
                }
                return Optional.of((Object)new EntityResponseWriter<T>(){

                    @Override
                    public Type getType() {
                        return Void.TYPE;
                    }

                    @Override
                    public void sendResponse(HttpStatus status, T value, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
                        resp.setStatus(status == HttpStatus.OK ? HttpStatus.NO_CONTENT : status);
                        ctx.getLifecycleListener().onBeforeWriteContent(req, resp);
                        ctx.getLifecycleListener().onAfterWriteContent(req, resp);
                    }
                });
            }
        };
    }

    public static class VoidEntityRequestBodyReader
    implements EntityRequestBodyReader<Void> {
        public static final VoidEntityRequestBodyReader INSTANCE = new VoidEntityRequestBodyReader();

        @Override
        public Type getType() {
            return Void.TYPE;
        }

        @Override
        public Void readBody(RestxRequest req, RestxContext ctx) throws IOException {
            return null;
        }
    }
}

