/*
 * Decompiled with CFR 0.152.
 */
package restx.entity;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import java.lang.reflect.Type;
import restx.entity.EntityContentTypeResolver;
import restx.entity.EntityDefaultContentTypeProvider;
import restx.entity.EntityRequestBodyReader;
import restx.entity.EntityRequestBodyReaderFactory;
import restx.factory.Component;

@Component
public class EntityRequestBodyReaderRegistry {
    private final EntityContentTypeResolver entityContentTypeResolver;
    private final Iterable<EntityRequestBodyReaderFactory> entityRequestBodyReaderFactories;

    public EntityRequestBodyReaderRegistry(Iterable<EntityDefaultContentTypeProvider> entityDefaultContentTypeProviders, Iterable<EntityRequestBodyReaderFactory> entityRequestBodyReaderFactories) {
        this.entityContentTypeResolver = new EntityContentTypeResolver(entityDefaultContentTypeProviders);
        this.entityRequestBodyReaderFactories = entityRequestBodyReaderFactories;
    }

    public <T> EntityRequestBodyReader<T> build(Type type, Optional<String> contentType) {
        String ct = this.entityContentTypeResolver.resolveContentType(type, contentType);
        for (EntityRequestBodyReaderFactory readerFactory : this.entityRequestBodyReaderFactories) {
            Optional reader = readerFactory.mayBuildFor(type, ct);
            if (!reader.isPresent()) continue;
            return (EntityRequestBodyReader)reader.get();
        }
        throw new IllegalStateException(String.format("no EntityRequestBodyReader built for %s %s.\n\nThe list of factories are:\n%s.\n\nThis may be because the content type '%s' is not handled by your RESTX install.\n\nPossible causes:\n  - you set the content type manually and mistyped it\n  - you are missing the EntityRequestBodyReaderFactory for this content type in your classpath\n", type, ct, Joiner.on((String)"\n\t").join(this.entityRequestBodyReaderFactories), ct));
    }
}

