/*
 * Decompiled with CFR 0.152.
 */
package restx.endpoint.mappers;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.google.common.base.Optional;
import java.lang.reflect.Type;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.converters.MainStringConverter;
import restx.endpoint.EndpointParamDef;
import restx.endpoint.EndpointParameterKind;
import restx.endpoint.mappers.EndpointParameterMapper;
import restx.factory.Component;

@Component
public class BaseTypeEndpointParameterMapper
implements EndpointParameterMapper {
    final MainStringConverter converter;

    public BaseTypeEndpointParameterMapper(MainStringConverter converter) {
        this.converter = converter;
    }

    @Override
    public <T> T mapRequest(EndpointParamDef endpointParamDef, RestxRequest request, RestxRequestMatch match, EndpointParameterKind parameterKind) {
        Optional<String> queryParamStrValue = parameterKind.extractQueryParamStringedValueFor(endpointParamDef, request, match);
        return this.convertRequestParamValue(queryParamStrValue, endpointParamDef.getType(), endpointParamDef.getRawType());
    }

    public <T> T convertRequestParamValue(Optional<String> queryParamStrValue, Type paramType, Class paramRawType) {
        if (String.class == paramType) {
            return (T)queryParamStrValue.orNull();
        }
        if (queryParamStrValue.isPresent()) {
            return this.converter.convert((String)queryParamStrValue.get(), paramRawType);
        }
        return null;
    }

    public boolean isBaseTypeParam(EndpointParamDef endpointParamDef) {
        return this.converter.canDeserialize((JavaType)SimpleType.construct((Class)endpointParamDef.getRawType()));
    }
}

