/*
 * Decompiled with CFR 0.152.
 */
package restx.endpoint;

import java.util.Objects;

public class Endpoint {
    private final String method;
    private final String pathPattern;

    public Endpoint(String method, String pathPattern) {
        this.pathPattern = pathPattern;
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathPattern() {
        return this.pathPattern;
    }

    public static Endpoint of(String method, String pathPattern) {
        return new Endpoint(method, pathPattern);
    }

    public String toString() {
        return this.method + " " + this.pathPattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Endpoint)) {
            return false;
        }
        Endpoint endpoint = (Endpoint)o;
        return Objects.equals(this.method, endpoint.method) && Objects.equals(this.pathPattern, endpoint.pathPattern);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.pathPattern);
    }
}

