/*
 * Decompiled with CFR 0.152.
 */
package restx;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import restx.AbstractRequest;
import restx.HttpSettings;
import restx.factory.Factory;

public class StdRequest
extends AbstractRequest {
    private final String localScheme;
    private final String baseApiPath;
    private final String baseUri;
    private final String restxPath;
    private final String httpMethod;
    private final ImmutableMap<String, String> headers;
    private final ImmutableMap<String, ImmutableList<String>> queryParams;
    private final ImmutableMap<String, String> cookiesMap;
    private final Supplier<InputStream> inputStreamSupplier;
    private InputStream inputStream;

    public static StdRequestBuilder builder() {
        return new StdRequestBuilder();
    }

    private StdRequest(String baseUri, String restxPath, String httpMethod, ImmutableMap<String, String> headers, ImmutableMap<String, ImmutableList<String>> queryParams, ImmutableMap<String, String> cookiesMap, Supplier<InputStream> inputStreamSupplier) {
        super((HttpSettings)Factory.getInstance().getComponent(HttpSettings.class));
        this.baseUri = (String)Preconditions.checkNotNull((Object)baseUri, (Object)"baseUri is required");
        this.restxPath = (String)Preconditions.checkNotNull((Object)restxPath, (Object)"restxPath is required");
        this.httpMethod = (String)Preconditions.checkNotNull((Object)httpMethod, (Object)"httpMethod is required");
        this.queryParams = (ImmutableMap)Preconditions.checkNotNull(queryParams, (Object)"query params are required");
        this.cookiesMap = (ImmutableMap)Preconditions.checkNotNull(cookiesMap, (Object)"cookies map is required");
        this.headers = (ImmutableMap)Preconditions.checkNotNull(headers, (Object)"headers is required");
        this.inputStreamSupplier = (Supplier)Preconditions.checkNotNull(inputStreamSupplier, (Object)"inputstream supplier is required");
        this.localScheme = this.getSchemeFromBaseUri(baseUri);
        this.baseApiPath = this.getBaseApiPathFromBaseUri(baseUri);
    }

    private String getBaseApiPathFromBaseUri(String baseUri) {
        return baseUri.replaceAll("^[^:]+://[^/]+/", "/");
    }

    private String getSchemeFromBaseUri(String baseUri) {
        try {
            return new URI(baseUri).getScheme();
        }
        catch (URISyntaxException e) {
            return "http";
        }
    }

    @Override
    protected String getBaseApiPath() {
        return this.baseApiPath;
    }

    @Override
    protected String getLocalScheme() {
        return this.localScheme;
    }

    @Override
    public String getBaseUri() {
        return this.baseUri;
    }

    @Override
    public String getBaseNetworkPath() {
        return this.getBaseUri().replaceAll("^https?:", "");
    }

    @Override
    public String getRestxPath() {
        return this.restxPath;
    }

    @Override
    public String getRestxUri() {
        if (this.queryParams.isEmpty()) {
            return this.restxPath;
        }
        StringBuilder sb = new StringBuilder(this.restxPath).append("?");
        for (Map.Entry entry : this.queryParams.entrySet()) {
            for (String val : (ImmutableList)entry.getValue()) {
                sb.append((String)entry.getKey()).append("=").append(val).append("&");
            }
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    @Override
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public Optional<String> getQueryParam(String param) {
        return Optional.fromNullable((Object)((String)Iterables.getFirst(this.getQueryParams(param), null)));
    }

    public ImmutableList<String> getQueryParams(String param) {
        return (ImmutableList)Optional.fromNullable((Object)((ImmutableList)this.queryParams.get((Object)param))).or((Object)ImmutableList.of());
    }

    @Override
    public ImmutableMap<String, ImmutableList<String>> getQueryParams() {
        return this.queryParams;
    }

    @Override
    public Optional<String> getHeader(String headerName) {
        return Optional.fromNullable((Object)((String)this.headers.get((Object)headerName)));
    }

    @Override
    public String getContentType() {
        return (String)this.headers.get((Object)"Content-type");
    }

    @Override
    public Optional<String> getCookieValue(String cookieName) {
        return Optional.fromNullable((Object)((String)this.cookiesMap.get((Object)cookieName)));
    }

    @Override
    public boolean isPersistentCookie(String cookie) {
        return false;
    }

    @Override
    public ImmutableMap<String, String> getCookiesMap() {
        return this.cookiesMap;
    }

    @Override
    public String getLocalClientAddress() {
        return "";
    }

    @Override
    public synchronized InputStream getContentStream() throws IOException {
        if (this.inputStream != null) {
            throw new IllegalStateException("can't get content stream multiple times");
        }
        this.inputStream = (InputStream)this.inputStreamSupplier.get();
        return this.inputStream;
    }

    @Override
    public synchronized void closeContentStream() throws IOException {
        if (this.inputStream == null) {
            throw new IllegalStateException("can't close content stream which is not opened");
        }
        this.inputStream.close();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        throw new IllegalArgumentException("no underlying implementation");
    }

    @Override
    public Locale getLocale() {
        List<String> languages = this.getLanguages();
        Locale locale = languages.isEmpty() ? Locale.getDefault() : Locale.forLanguageTag(languages.get(0));
        return locale;
    }

    private List<String> getLanguages() {
        String acceptLanguageHeader = (String)this.headers.get((Object)"Accept-Language");
        ArrayList<String> languages = new ArrayList<String>();
        if (!Strings.isNullOrEmpty((String)acceptLanguageHeader)) {
            Iterable split = Splitter.on((String)",").split((CharSequence)acceptLanguageHeader.replace(" ", "").replace(";", ","));
            for (String s1 : split) {
                if (s1.startsWith("q=")) continue;
                languages.add(s1);
            }
        }
        return languages;
    }

    @Override
    public ImmutableList<Locale> getLocales() {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        for (String language : this.getLanguages()) {
            Locale locale = Locale.forLanguageTag(language);
            if (locale == null) continue;
            locales.add(locale);
        }
        if (locales.isEmpty()) {
            locales.add(Locale.getDefault());
        }
        return ImmutableList.copyOf(locales);
    }

    public static class StdRequestBuilder {
        private String baseUri;
        private String restxPath;
        private String httpMethod = "GET";
        private ImmutableMap<String, String> headers = ImmutableMap.of();
        private ImmutableMap<String, ImmutableList<String>> queryParams = ImmutableMap.of();
        private ImmutableMap<String, String> cookiesMap = ImmutableMap.of();
        private Supplier<InputStream> inputStreamSupplier = new Supplier<InputStream>(){

            public InputStream get() {
                throw new UnsupportedOperationException();
            }
        };

        public StdRequestBuilder setFullPath(String fullPath) {
            int queryStringIndex = fullPath.indexOf(63);
            if (queryStringIndex == -1) {
                this.restxPath = fullPath;
                return this;
            }
            this.restxPath = fullPath.substring(0, queryStringIndex);
            LinkedHashMap params = Maps.newLinkedHashMap();
            Iterator iterator = Splitter.on((String)"&").split((CharSequence)fullPath.substring(queryStringIndex + 1)).iterator();
            while (iterator.hasNext()) {
                List paramValues;
                String queryParam;
                String param = queryParam = (String)iterator.next();
                String val = "";
                int eqIndex = queryParam.indexOf(61);
                if (eqIndex != -1) {
                    param = queryParam.substring(0, eqIndex);
                    val = queryParam.substring(eqIndex + 1);
                }
                if ((paramValues = (List)params.get(param)) == null) {
                    paramValues = Lists.newArrayList();
                    params.put(param, paramValues);
                }
                paramValues.add(val);
            }
            ImmutableMap.Builder paramsBuilder = ImmutableMap.builder();
            for (Map.Entry entry : params.entrySet()) {
                paramsBuilder.put((Object)((String)entry.getKey()), (Object)ImmutableList.copyOf((Collection)((Collection)entry.getValue())));
            }
            this.queryParams = paramsBuilder.build();
            return this;
        }

        public StdRequestBuilder setBaseUri(String baseUri) {
            this.baseUri = baseUri;
            return this;
        }

        public StdRequestBuilder setRestxPath(String restxPath) {
            this.restxPath = restxPath;
            return this;
        }

        public StdRequestBuilder setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public StdRequestBuilder setHeaders(ImmutableMap<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public StdRequestBuilder setQueryParams(ImmutableMap<String, ImmutableList<String>> queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public StdRequestBuilder setCookiesMap(ImmutableMap<String, String> cookiesMap) {
            this.cookiesMap = cookiesMap;
            return this;
        }

        public StdRequestBuilder setInputStreamSupplier(Supplier<InputStream> inputStreamSupplier) {
            this.inputStreamSupplier = inputStreamSupplier;
            return this;
        }

        public StdRequest build() {
            return new StdRequest(this.baseUri, this.restxPath, this.httpMethod, this.headers, this.queryParams, this.cookiesMap, this.inputStreamSupplier);
        }
    }
}

