/*
 * Decompiled with CFR 0.152.
 */
package restx;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import restx.RestxFilter;
import restx.RestxHandlerMatch;
import restx.RestxRequest;
import restx.RestxRoute;
import restx.RestxRouteFilter;
import restx.factory.Factory;
import restx.factory.NamedComponent;

public class RestxRouting {
    private final ImmutableList<NamedComponent<RestxFilter>> filters;
    private final ImmutableMultimap<RestxRoute, NamedComponent<RestxHandlerMatch>> routeFilters;
    private final ImmutableList<RestxRoute> routes;

    public RestxRouting(ImmutableList<NamedComponent<RestxFilter>> filters, ImmutableList<NamedComponent<RestxRouteFilter>> routeFilters, ImmutableList<RestxRoute> routes) {
        this.filters = filters;
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (RestxRoute route : routes) {
            for (NamedComponent routeFilter : routeFilters) {
                Optional<RestxHandlerMatch> m = ((RestxRouteFilter)routeFilter.getComponent()).match(route);
                if (!m.isPresent()) continue;
                RestxHandlerMatch restxHandlerMatch = (RestxHandlerMatch)m.get();
                builder.put((Object)route, (Object)NamedComponent.of(RestxHandlerMatch.class, (String)routeFilter.getName().getName(), (int)routeFilter.getPriority(), (Object)restxHandlerMatch));
            }
        }
        this.routeFilters = builder.build();
        this.routes = routes;
    }

    public ImmutableList<RestxFilter> getFilters() {
        return ImmutableList.copyOf((Iterable)Iterables.transform(this.filters, (Function)NamedComponent.toComponent()));
    }

    public ImmutableCollection<? extends RestxHandlerMatch> getRouteFilters(RestxRoute route) {
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)this.routeFilters.get((Object)route), (Function)NamedComponent.toComponent()));
    }

    public ImmutableList<RestxRoute> getRoutes() {
        return this.routes;
    }

    public Optional<Match> match(RestxRequest restxRequest) {
        for (RestxRoute route : this.routes) {
            Optional<RestxHandlerMatch> match = route.match(restxRequest);
            if (!match.isPresent()) continue;
            ImmutableCollection routeFilters = this.routeFilters.get((Object)route);
            ArrayList matches = Lists.newArrayListWithCapacity((int)(this.filters.size() + routeFilters.size() + 1));
            matches.addAll(routeFilters);
            for (NamedComponent filter : this.filters) {
                Optional<RestxHandlerMatch> filterMatch = ((RestxFilter)filter.getComponent()).match(restxRequest);
                if (!filterMatch.isPresent()) continue;
                matches.add(NamedComponent.of(RestxHandlerMatch.class, (String)filter.getName().getName(), (int)filter.getPriority(), (Object)((RestxHandlerMatch)filterMatch.get())));
            }
            return Optional.of((Object)new Match((ImmutableList<RestxHandlerMatch>)ImmutableList.builder().addAll(Iterables.transform((Iterable)Ordering.from((Comparator)Factory.NAMED_COMPONENT_COMPARATOR).sortedCopy((Iterable)matches), (Function)NamedComponent.toComponent())).add((Object)((RestxHandlerMatch)match.get())).build(), match));
        }
        return Optional.absent();
    }

    public static class Match {
        private final ImmutableList<RestxHandlerMatch> matches;
        private final Optional<? extends RestxHandlerMatch> match;

        private Match(ImmutableList<RestxHandlerMatch> matches, Optional<? extends RestxHandlerMatch> match) {
            this.matches = matches;
            this.match = match;
        }

        public ImmutableList<RestxHandlerMatch> getMatches() {
            return this.matches;
        }

        public Optional<? extends RestxHandlerMatch> getMatch() {
            return this.match;
        }

        public String toString() {
            return "Match{matches=" + this.matches + ", match=" + this.match + "}";
        }
    }
}

