/*
 * Decompiled with CFR 0.152.
 */
package restx;

import com.google.common.base.Stopwatch;
import org.slf4j.Logger;
import restx.RestxRequest;
import restx.RestxResponse;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum RestxLogLevel {
    VERBOSE{

        @Override
        public void log(Logger logger, RestxRequest restxRequest, RestxResponse restxResponse, Stopwatch stopwatch) {
            logger.info("<< {}\n{}\n>> {} - {}", new Object[]{restxRequest, restxRequest.getCookiesMap(), restxResponse.getStatus(), stopwatch});
        }
    }
    ,
    DEFAULT{

        @Override
        public void log(Logger logger, RestxRequest restxRequest, RestxResponse restxResponse, Stopwatch stopwatch) {
            logger.info("<< {} >> {} - {}", new Object[]{restxRequest, restxResponse.getStatus(), stopwatch});
        }
    }
    ,
    QUIET{

        @Override
        public void log(Logger logger, RestxRequest restxRequest, RestxResponse restxResponse, Stopwatch stopwatch) {
            logger.debug("<< {} >> {} - {}", new Object[]{restxRequest, restxResponse.getStatus(), stopwatch});
        }
    };


    public abstract void log(Logger var1, RestxRequest var2, RestxResponse var3, Stopwatch var4);
}

