/*
 * Decompiled with CFR 0.152.
 */
package restx;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.IOException;
import restx.RestxContext;
import restx.RestxHandler;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;

public final class RestxHandlerMatch {
    private final RestxRequestMatch match;
    private final RestxHandler handler;

    public static Optional<RestxHandlerMatch> of(Optional<? extends RestxRequestMatch> match, RestxHandler handler) {
        return RestxHandlerMatch.of(match, (Supplier<? extends RestxHandler>)Suppliers.ofInstance((Object)handler));
    }

    public static Optional<RestxHandlerMatch> of(Optional<? extends RestxRequestMatch> match, Supplier<? extends RestxHandler> handler) {
        return match.isPresent() ? Optional.of((Object)new RestxHandlerMatch((RestxRequestMatch)match.get(), (RestxHandler)handler.get())) : Optional.absent();
    }

    public RestxHandlerMatch(RestxRequestMatch match, RestxHandler handler) {
        this.match = match;
        this.handler = handler;
    }

    public RestxRequestMatch getMatch() {
        return this.match;
    }

    public RestxHandler getHandler() {
        return this.handler;
    }

    public void handle(RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
        this.handler.handle(this.match, req, resp, ctx);
    }

    public String toString() {
        return "RestxHandlerMatch{match=" + this.match + ", handler=" + this.handler + "}";
    }
}

