/*
 * Decompiled with CFR 0.152.
 */
package restx;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import restx.RestxContext;
import restx.RestxHandler;
import restx.RestxHandlerMatch;
import restx.RestxLogLevel;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.RestxRoute;
import restx.StdRestxRequestMatch;
import restx.common.MoreResources;
import restx.http.HTTP;
import restx.http.HttpStatus;

public class ResourcesRoute
implements RestxRoute,
RestxHandler {
    private final String name;
    private final String baseRestPath;
    private final String baseResourcePath;
    private final ImmutableMap<String, String> aliases;
    private final ImmutableList<CachedResourcePolicy> cachedResourcePolicies;

    public ResourcesRoute(String name, String baseRestPath, String baseResourcePath) {
        this(name, baseRestPath, baseResourcePath, (ImmutableMap<String, String>)ImmutableMap.of());
    }

    public ResourcesRoute(String name, String baseRestPath, String baseResourcePath, ImmutableMap<String, String> aliases) {
        this(name, baseRestPath, baseResourcePath, aliases, Collections.emptyList());
    }

    public ResourcesRoute(String name, String baseRestPath, String baseResourcePath, ImmutableMap<String, String> aliases, List<CachedResourcePolicy> cachedResourcePolicies) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.baseRestPath = ("/" + (String)Preconditions.checkNotNull((Object)baseRestPath) + "/").replaceAll("/+", "/");
        this.baseResourcePath = this.ensureBaseResourcePathValid(baseResourcePath);
        this.aliases = (ImmutableMap)Preconditions.checkNotNull(aliases);
        this.cachedResourcePolicies = ImmutableList.copyOf(cachedResourcePolicies);
    }

    protected String ensureBaseResourcePathValid(String baseResourcePath) {
        String escapedBaseResourcePath = ((String)Preconditions.checkNotNull((Object)baseResourcePath)).replace('.', '/').replaceAll("^/", "").replaceAll("/$", "") + "/";
        if ("/".equals(escapedBaseResourcePath)) {
            throw new IllegalArgumentException("Please, avoid using '/' as ResourcesRoute's baseResourcePath as it represents serious security flaws (people will be able to read your classpath configuration files)");
        }
        return escapedBaseResourcePath;
    }

    @Override
    public Optional<RestxHandlerMatch> match(RestxRequest req) {
        if (req.getHttpMethod().equals("GET") && req.getRestxPath().startsWith(this.baseRestPath)) {
            return Optional.of((Object)new RestxHandlerMatch(new StdRestxRequestMatch(this.baseRestPath + "*", req.getRestxPath()), this));
        }
        return Optional.absent();
    }

    @Override
    public void handle(RestxRequestMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
        String relativePath = this.requestRelativePath(req);
        relativePath = (String)Optional.fromNullable((Object)((String)this.aliases.get((Object)relativePath))).or((Object)relativePath);
        try {
            URL resource = MoreResources.getResource((String)(this.baseResourcePath + relativePath), ("dev".equals(ctx.getMode()) || "test".equals(ctx.getMode()) || "infinirest".equals(ctx.getMode()) ? 1 : 0) != 0);
            this.serveCacheableResource(resp, resource, relativePath);
        }
        catch (IllegalArgumentException e) {
            this.notFound(resp, relativePath);
        }
    }

    protected String requestRelativePath(RestxRequest req) {
        return req.getRestxPath().substring(this.baseRestPath.length());
    }

    protected void serveCacheableResource(RestxResponse resp, URL resource, String relativePath) throws IOException {
        String contentType = (String)HTTP.getContentTypeFromExtension(relativePath).or((Object)"application/octet-stream");
        ImmutableMap.Builder headers = ImmutableMap.builder();
        Optional<CachedResourcePolicy> cachedResourcePolicy = this.cachePolicyMatching(contentType, relativePath);
        if (cachedResourcePolicy.isPresent()) {
            headers.put((Object)"Cache-Control", (Object)((CachedResourcePolicy)cachedResourcePolicy.get()).getCacheValue());
        }
        this.serveResource(resp, resource, contentType, (Map<String, String>)headers.build());
    }

    protected void serveResource(RestxResponse resp, URL resource, String contentType) throws IOException {
        this.serveResource(resp, resource, contentType, (Map<String, String>)ImmutableMap.of());
    }

    protected void serveResource(RestxResponse resp, URL resource, String contentType, Map<String, String> headers) throws IOException {
        resp.setLogLevel(RestxLogLevel.QUIET);
        resp.setStatus(HttpStatus.OK);
        for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
            resp.setHeader(headerEntry.getKey(), headerEntry.getValue());
        }
        resp.setContentType(contentType);
        Resources.asByteSource((URL)resource).copyTo(resp.getOutputStream());
    }

    protected Optional<CachedResourcePolicy> cachePolicyMatching(String contentType, String path) {
        for (CachedResourcePolicy cachedResourcePolicy : this.cachedResourcePolicies) {
            if (!cachedResourcePolicy.matches(contentType, path)) continue;
            return Optional.of((Object)cachedResourcePolicy);
        }
        return Optional.absent();
    }

    protected void notFound(RestxResponse resp, String relativePath) throws IOException {
        resp.setStatus(HttpStatus.NOT_FOUND);
        resp.setContentType("text/plain");
        resp.getWriter().println("Resource route matched '" + this + "', but resource " + relativePath + " not found in " + this.baseResourcePath + ".");
    }

    public String getName() {
        return this.name;
    }

    public String getBaseRestPath() {
        return this.baseRestPath;
    }

    public String getBaseResourcePath() {
        return this.baseResourcePath;
    }

    public String toString() {
        return "GET " + this.baseRestPath + "* => " + this.name;
    }

    public static class CachedResourcePolicy {
        final Predicate<ResourceInfo> matcher;
        final String cacheValue;

        public CachedResourcePolicy(Predicate<ResourceInfo> matcher, String cacheValue) {
            this.matcher = matcher;
            this.cacheValue = cacheValue;
        }

        public boolean matches(String contentType, String path) {
            return this.matcher.apply((Object)new ResourceInfo(contentType, path));
        }

        public String getCacheValue() {
            return this.cacheValue;
        }
    }

    public static class ResourceInfo {
        final String contentType;
        final String path;

        public ResourceInfo(String contentType, String path) {
            this.contentType = contentType;
            this.path = path;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getPath() {
            return this.path;
        }
    }
}

