/*
 * Decompiled with CFR 0.152.
 */
package restx;

import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.EventBus;
import restx.CoreModule;
import restx.common.UUIDGenerator;
import restx.common.metrics.api.health.HealthCheckRegistry;
import restx.config.ConfigLoader;
import restx.config.ConfigSupplier;
import restx.factory.AutoStartable;
import restx.factory.BillOfMaterials;
import restx.factory.BoundlessComponentBox;
import restx.factory.DefaultFactoryMachine;
import restx.factory.Factory;
import restx.factory.Machine;
import restx.factory.MachineEngine;
import restx.factory.Name;
import restx.factory.NamedComponent;
import restx.factory.SatisfiedBOM;
import restx.factory.StdMachineEngine;

@Machine
public class CoreModuleFactoryMachine
extends DefaultFactoryMachine {
    private static final CoreModule module = new CoreModule();

    public CoreModuleFactoryMachine() {
        super(10000, new MachineEngine[]{new StdMachineEngine<ConfigSupplier>(Name.of(ConfigSupplier.class, (String)"coreAppConfigSupplier"), 10000, BoundlessComponentBox.FACTORY){
            private final Factory.Query<ConfigLoader> configLoader = Factory.Query.byClass(ConfigLoader.class).mandatory();

            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.of(this.configLoader));
            }

            public ConfigSupplier doNewComponent(SatisfiedBOM satisfiedBOM) {
                return module.coreAppConfigSupplier((ConfigLoader)((NamedComponent)satisfiedBOM.getOne(this.configLoader).get()).getComponent());
            }
        }, new StdMachineEngine<ConfigSupplier>(Name.of(ConfigSupplier.class, (String)"httpConfigSupplier"), 10000, BoundlessComponentBox.FACTORY){
            private final Factory.Query<ConfigLoader> configLoader = Factory.Query.byClass(ConfigLoader.class).mandatory();

            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.of(this.configLoader));
            }

            public ConfigSupplier doNewComponent(SatisfiedBOM satisfiedBOM) {
                return module.httpConfigSupplier((ConfigLoader)((NamedComponent)satisfiedBOM.getOne(this.configLoader).get()).getComponent());
            }
        }, new StdMachineEngine<EventBus>(Name.of(EventBus.class, (String)"eventBus"), 10000, BoundlessComponentBox.FACTORY){

            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.of());
            }

            public EventBus doNewComponent(SatisfiedBOM satisfiedBOM) {
                return module.eventBus();
            }
        }, new StdMachineEngine<AutoStartable>(Name.of(AutoStartable.class, (String)"loadEventBusOnStartUp"), 10000, BoundlessComponentBox.FACTORY){
            private final Factory.Query<EventBus> eventBus = Factory.Query.byClass(EventBus.class).mandatory();

            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.of(this.eventBus));
            }

            public AutoStartable doNewComponent(SatisfiedBOM satisfiedBOM) {
                return module.loadEventBusOnStartUp((EventBus)((NamedComponent)satisfiedBOM.getOne(this.eventBus).get()).getComponent());
            }
        }, new StdMachineEngine<HealthCheckRegistry>(Name.of(HealthCheckRegistry.class, (String)"HealthChekcRegistry"), 10000, BoundlessComponentBox.FACTORY){

            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.of());
            }

            public HealthCheckRegistry doNewComponent(SatisfiedBOM satisfiedBOM) {
                return module.healthCheckRegistry();
            }
        }, new StdMachineEngine<UUIDGenerator>(Name.of(UUIDGenerator.class, (String)"UUIDGenerator"), 10000, BoundlessComponentBox.FACTORY){

            public BillOfMaterials getBillOfMaterial() {
                return new BillOfMaterials(ImmutableSet.of());
            }

            public UUIDGenerator doNewComponent(SatisfiedBOM satisfiedBOM) {
                return module.uuidGenerator();
            }
        }});
    }
}

