/*
 * Decompiled with CFR 0.152.
 */
package restx;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import restx.AppSettings;
import restx.common.RestxConfig;
import restx.factory.Component;

@Component(priority=1000)
public class AppSettingsConfig
implements AppSettings {
    private final RestxConfig config;

    public AppSettingsConfig(RestxConfig config) {
        this.config = config;
    }

    @Override
    public Optional<String> appPackage() {
        return this.config.getString("restx.app.package");
    }

    @Override
    public String targetClasses() {
        return (String)this.config.getString("restx.targetClasses").get();
    }

    @Override
    public String targetDependency() {
        return (String)this.config.getString("restx.targetDependency").get();
    }

    @Override
    public String sourceRoots() {
        return (String)this.config.getString("restx.sourceRoots").get();
    }

    @Override
    public String mainSources() {
        return (String)this.config.getString("restx.mainSources").get();
    }

    @Override
    public String mainResources() {
        return (String)this.config.getString("restx.mainResources").get();
    }

    @Override
    public String cachedResources() {
        return (String)this.config.getString("restx.cache.cachedResources").or((Object)"");
    }

    @Override
    public Optional<Boolean> autoCompile() {
        return this.config.getBoolean("restx.router.autocompile");
    }

    @Override
    public Optional<Boolean> hotCompile() {
        return this.config.getBoolean("restx.router.hotcompile");
    }

    @Override
    public Optional<Boolean> hotReload() {
        return this.config.getBoolean("restx.router.hotreload");
    }

    @Override
    public String mode() {
        return (String)this.config.getString("restx.mode").get();
    }

    @Override
    public Optional<String> factoryLoadMode() {
        return Optional.fromNullable((Object)Strings.emptyToNull((String)((String)this.config.getString("restx.factory.load").or((Object)""))));
    }

    @Override
    public Optional<String> coldClasses() {
        return Optional.fromNullable((Object)Strings.emptyToNull((String)((String)this.config.getString("restx.cold.classes").or((Object)""))));
    }
}

