/*
 * Decompiled with CFR 0.152.
 */
package restx;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.RestxLogLevel;
import restx.RestxResponse;
import restx.http.HTTP;
import restx.http.HttpStatus;
import restx.security.RestxSessionCookieDescriptor;

public abstract class AbstractResponse<R>
implements RestxResponse {
    private static final Logger logger = LoggerFactory.getLogger(AbstractResponse.class);
    private final Class<R> responseClass;
    private final R response;
    private HttpStatus status = HttpStatus.OK;
    private Charset charset;
    private PrintWriter writer;
    private OutputStream outputStream;
    private RestxLogLevel logLevel = RestxLogLevel.DEFAULT;
    private boolean closed;
    private final Map<String, String> headers = new LinkedHashMap<String, String>();

    protected AbstractResponse(Class<R> responseClass, R response) {
        this.responseClass = responseClass;
        this.response = response;
    }

    @Override
    public HttpStatus getStatus() {
        return this.status;
    }

    @Override
    public RestxResponse setStatus(HttpStatus httpStatus) {
        this.status = httpStatus;
        this.doSetStatus(httpStatus);
        return this;
    }

    @Override
    public RestxResponse setContentType(String s) {
        if (HTTP.isTextContentType((String)s)) {
            Optional<String> cs = HTTP.charsetFromContentType((String)s);
            if (!cs.isPresent()) {
                s = (String)s + "; charset=UTF-8";
                this.charset = Charsets.UTF_8;
            } else {
                this.charset = Charset.forName((String)cs.get());
            }
        }
        this.setHeader("Content-Type", (String)s);
        return this;
    }

    @Override
    public Optional<Charset> getCharset() {
        return Optional.fromNullable((Object)this.charset);
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.charset == null) {
            logger.warn("no charset defined while getting writer to write http response. Make sure you call setContentType() before calling getWriter(). Using UTF-8 charset.");
            this.charset = Charsets.UTF_8;
        }
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.doGetOutputStream(), this.charset), true);
        return this.writer;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.outputStream != null) {
            return this.outputStream;
        }
        this.outputStream = this.doGetOutputStream();
        return this.outputStream;
    }

    @Override
    public void close() throws Exception {
        if (this.isClosed()) {
            return;
        }
        try {
            if (this.writer != null) {
                this.writer.print("\n");
                this.writer.flush();
                this.writer.close();
            }
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            this.closeResponse();
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public RestxLogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public RestxResponse setLogLevel(RestxLogLevel logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    @Override
    public RestxResponse addCookie(String cookie, String value, RestxSessionCookieDescriptor cookieDescriptor) {
        this.addCookie(cookie, value, cookieDescriptor, Duration.ZERO);
        return this;
    }

    @Override
    public final RestxResponse setHeader(String headerName, String header) {
        this.doSetHeader(headerName, header);
        this.headers.put(headerName.toLowerCase(Locale.ENGLISH), header);
        return this;
    }

    protected abstract void doSetHeader(String var1, String var2);

    @Override
    public Optional<String> getHeader(String headerName) {
        return Optional.fromNullable((Object)this.headers.get(headerName.toLowerCase(Locale.ENGLISH)));
    }

    public String toString() {
        return "[RESTX RESPONSE] " + this.status;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz == this.responseClass) {
            return (T)this.response;
        }
        throw new IllegalArgumentException("underlying implementation is " + this.responseClass.getName() + ", not " + clazz.getName());
    }

    protected abstract void closeResponse() throws IOException;

    protected abstract OutputStream doGetOutputStream() throws IOException;

    protected abstract void doSetStatus(HttpStatus var1);
}

