/*
 * Decompiled with CFR 0.152.
 */
package restx;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import restx.HttpSettings;
import restx.RestxRequest;

public abstract class AbstractRequest
implements RestxRequest {
    protected final HttpSettings httpSettings;

    protected AbstractRequest(HttpSettings httpSettings) {
        this.httpSettings = httpSettings;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[RESTX REQUEST] ");
        sb.append(this.getHttpMethod()).append(" ").append(this.getRestxPath());
        this.dumpParameters(sb);
        return sb.toString();
    }

    private void dumpParameters(StringBuilder sb) {
        ImmutableMap<String, ImmutableList<String>> queryParams = this.getQueryParams();
        if (queryParams.isEmpty()) {
            return;
        }
        sb.append(" ? ");
        for (Map.Entry entry : queryParams.entrySet()) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            sb.append(key).append("=").append(values.size() == 1 ? (String)values.get(0) : Joiner.on((String)("&" + key + "=")).join((Iterable)values));
            sb.append("&");
        }
        sb.setLength(sb.length() - 1);
    }

    @Override
    public String getBaseUri() {
        return this.getScheme() + ":" + this.getBaseNetworkPath();
    }

    @Override
    public String getBaseNetworkPath() {
        this.checkProxyRequest();
        return "//" + this.getHost() + this.getBaseApiPath();
    }

    protected String getHost() {
        Optional<String> host = this.httpSettings.host();
        if (host.isPresent()) {
            return (String)host.get();
        }
        Optional<String> forwardedHost = this.getHeader("X-Forwarded-Host");
        if (forwardedHost.isPresent()) {
            return (String)Iterables.getFirst((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)forwardedHost.get()), (Object)((String)this.getHeader("Host").or((Object)"")));
        }
        return (String)this.getHeader("Host").or((Object)"");
    }

    @Override
    public boolean isSecured() {
        this.checkProxyRequest();
        return this.getScheme().equalsIgnoreCase("https");
    }

    protected String getScheme() {
        Optional proto = this.httpSettings.scheme().or(this.getHeader("X-Forwarded-Proto"));
        if (proto.isPresent()) {
            return (String)proto.get();
        }
        Optional<String> via = this.getHeader("Via");
        if (via.isPresent()) {
            boolean secured = ((String)via.get()).toUpperCase(Locale.ENGLISH).startsWith("HTTPS");
            return secured ? "https" : "http";
        }
        return this.getLocalScheme();
    }

    @Override
    public String getClientAddress() {
        this.checkProxyRequest();
        Optional<String> xff = this.getHeader("X-Forwarded-For");
        if (xff.isPresent()) {
            return (String)Iterables.getFirst((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)xff.get()), (Object)this.getLocalClientAddress());
        }
        return this.getLocalClientAddress();
    }

    protected void checkProxyRequest() {
        if (this.getHeader("X-Forwarded-Proto").isPresent()) {
            String localClientAddress = this.getLocalClientAddress();
            Collection<String> forwardedSupport = this.httpSettings.forwardedSupport();
            if (!forwardedSupport.contains("all") && !forwardedSupport.contains(localClientAddress)) {
                throw new IllegalArgumentException("Unauthorized proxy request from " + localClientAddress + "\nIf you are the application developer or operator, you can set `restx.http.XForwardedSupport`\nsystem property to allow proxy requests from this proxy IP with:\n  -Drestx.http.XForwardedSupport=" + localClientAddress + "\nOr if you want to allow any proxy request:\n  -Drestx.http.XForwardedSupport=all");
            }
        }
    }

    protected abstract String getLocalClientAddress();

    protected abstract String getBaseApiPath();

    protected abstract String getLocalScheme();
}

