/*
 * Decompiled with CFR 0.152.
 */
package restx.admin;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.inject.Named;
import restx.RestxContext;
import restx.RestxFilter;
import restx.RestxHandler;
import restx.RestxHandlerMatch;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxResponse;
import restx.StdRestxRequestMatch;
import restx.WebException;
import restx.factory.Module;
import restx.factory.Provides;
import restx.http.HttpStatus;
import restx.security.BasicPrincipalAuthenticator;
import restx.security.PermissionFactory;
import restx.security.RestxPrincipal;
import restx.security.RestxSession;
import restx.security.SecuritySettings;
import restx.security.StdBasicPrincipalAuthenticator;
import restx.security.UserService;

@Module(priority=10000)
public class AdminModule {
    public static final String RESTX_ADMIN_ROLE = "restx-admin";
    public static final RestxAdminPrincipal RESTX_ADMIN_PRINCIPAL = new RestxAdminPrincipal();

    @Named(value="restx.admin.password")
    @Provides
    public String restxAdminPassword() {
        return "juma";
    }

    @Named(value="restx.admin.passwordHash")
    @Provides
    public String restxAdminPasswordHash(@Named(value="restx.admin.password") String password) {
        return Hashing.md5().hashString((CharSequence)password, Charsets.UTF_8).toString();
    }

    @Provides
    public BasicPrincipalAuthenticator basicPrincipalAuthenticator(final @Named(value="restx.admin.passwordHash") String adminPasswordHash, SecuritySettings securitySettings) {
        return new StdBasicPrincipalAuthenticator((UserService)new UserService<RestxAdminPrincipal>(){

            public Optional<RestxAdminPrincipal> findUserByName(String name) {
                return "admin".equals(name) ? Optional.of((Object)RESTX_ADMIN_PRINCIPAL) : Optional.absent();
            }

            public Optional<RestxAdminPrincipal> findAndCheckCredentials(String name, String passwordHash) {
                return "admin".equals(name) && adminPasswordHash.equals(passwordHash) ? Optional.of((Object)RESTX_ADMIN_PRINCIPAL) : Optional.absent();
            }
        }, securitySettings);
    }

    @Provides
    public RestxFilter adminRoleFilter(final PermissionFactory permissionFactory) {
        return new RestxFilter(){
            final Pattern privatePath = Pattern.compile("^/@/(?!(ui|webjars)/).*$");

            public Optional<RestxHandlerMatch> match(RestxRequest req) {
                if (this.privatePath.matcher(req.getRestxPath()).find()) {
                    return Optional.of((Object)new RestxHandlerMatch((RestxRequestMatch)new StdRestxRequestMatch("/@/*", req.getRestxPath()), new RestxHandler(){

                        public void handle(RestxRequestMatch match, RestxRequest req, RestxResponse resp, RestxContext ctx) throws IOException {
                            RestxSession current = RestxSession.current();
                            if (!current.getPrincipal().isPresent() || !permissionFactory.hasRole(AdminModule.RESTX_ADMIN_ROLE).has((RestxPrincipal)current.getPrincipal().get(), Collections.emptyMap()).isPresent()) {
                                throw new WebException(HttpStatus.UNAUTHORIZED);
                            }
                            ctx.nextHandlerMatch().handle(req, resp, ctx);
                        }
                    }));
                }
                return Optional.absent();
            }
        };
    }

    public static class RestxAdminPrincipal
    implements RestxPrincipal {
        public ImmutableSet<String> getPrincipalRoles() {
            return ImmutableSet.of((Object)AdminModule.RESTX_ADMIN_ROLE);
        }

        public String getName() {
            return "admin";
        }
    }
}

