/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.webtestclient.config;

import io.restassured.config.DecoderConfig;
import io.restassured.config.EncoderConfig;
import io.restassured.config.HeaderConfig;
import io.restassured.config.JsonConfig;
import io.restassured.config.LogConfig;
import io.restassured.config.MatcherConfig;
import io.restassured.config.MultiPartConfig;
import io.restassured.config.ObjectMapperConfig;
import io.restassured.config.ParamConfig;
import io.restassured.config.SessionConfig;
import io.restassured.config.XmlConfig;
import io.restassured.internal.common.assertion.AssertParameter;
import io.restassured.module.spring.commons.config.AsyncConfig;
import io.restassured.module.spring.commons.config.ClientConfig;
import io.restassured.module.spring.commons.config.SpecificationConfig;
import io.restassured.module.webtestclient.config.WebTestClientConfig;
import io.restassured.module.webtestclient.config.WebTestClientParamConfig;

public class RestAssuredWebTestClientConfig
implements SpecificationConfig {
    private final LogConfig logConfig;
    private final EncoderConfig encoderConfig;
    private final DecoderConfig decoderConfig;
    private final SessionConfig sessionConfig;
    private final ObjectMapperConfig objectMapperConfig;
    private final JsonConfig jsonConfig;
    private final XmlConfig xmlConfig;
    private final HeaderConfig headerConfig;
    private final AsyncConfig asyncConfig;
    private final WebTestClientConfig webTestClientConfig;
    private final MultiPartConfig multiPartConfig;
    private final WebTestClientParamConfig paramConfig;
    private final MatcherConfig matcherConfig;

    public RestAssuredWebTestClientConfig() {
        this(new LogConfig(), new EncoderConfig(), new DecoderConfig(), new SessionConfig(), new ObjectMapperConfig(), new JsonConfig(), new XmlConfig(), new HeaderConfig(), new AsyncConfig(), new MultiPartConfig(), new WebTestClientConfig(), new WebTestClientParamConfig(), new MatcherConfig());
    }

    private RestAssuredWebTestClientConfig(LogConfig logConfig, EncoderConfig encoderConfig, DecoderConfig decoderConfig, SessionConfig sessionConfig, ObjectMapperConfig objectMapperConfig, JsonConfig jsonConfig, XmlConfig xmlConfig, HeaderConfig headerConfig, AsyncConfig asyncConfig, MultiPartConfig multiPartConfig, WebTestClientConfig webTestClientConfig, WebTestClientParamConfig paramConfig, MatcherConfig matcherConfig) {
        AssertParameter.notNull((Object)logConfig, (String)"Log config");
        AssertParameter.notNull((Object)encoderConfig, (String)"Encoder config");
        AssertParameter.notNull((Object)decoderConfig, (String)"Decoder config");
        AssertParameter.notNull((Object)sessionConfig, (String)"Session config");
        AssertParameter.notNull((Object)objectMapperConfig, (String)"Object mapper config");
        AssertParameter.notNull((Object)jsonConfig, (String)"Json config");
        AssertParameter.notNull((Object)xmlConfig, (String)"Xml config");
        AssertParameter.notNull((Object)headerConfig, (String)"Header config");
        AssertParameter.notNull((Object)multiPartConfig, (String)"MultiPart config");
        AssertParameter.notNull((Object)webTestClientConfig, (String)"webTestClient config");
        AssertParameter.notNull((Object)((Object)paramConfig), (String)"Param config");
        AssertParameter.notNull((Object)matcherConfig, (String)"Matcher config");
        this.logConfig = logConfig;
        this.encoderConfig = encoderConfig;
        this.decoderConfig = decoderConfig;
        this.sessionConfig = sessionConfig;
        this.objectMapperConfig = objectMapperConfig;
        this.jsonConfig = jsonConfig;
        this.xmlConfig = xmlConfig;
        this.headerConfig = headerConfig;
        this.asyncConfig = asyncConfig;
        this.multiPartConfig = multiPartConfig;
        this.webTestClientConfig = webTestClientConfig;
        this.paramConfig = paramConfig;
        this.matcherConfig = matcherConfig;
    }

    public static RestAssuredWebTestClientConfig newConfig() {
        return new RestAssuredWebTestClientConfig();
    }

    public static RestAssuredWebTestClientConfig config() {
        return new RestAssuredWebTestClientConfig();
    }

    public RestAssuredWebTestClientConfig and() {
        return this;
    }

    public RestAssuredWebTestClientConfig set() {
        return this;
    }

    public RestAssuredWebTestClientConfig with() {
        return this;
    }

    public boolean isUserConfigured() {
        return this.decoderConfig.isUserConfigured() || this.encoderConfig.isUserConfigured() || this.logConfig.isUserConfigured() || this.sessionConfig.isUserConfigured() || this.objectMapperConfig.isUserConfigured() || this.xmlConfig.isUserConfigured() || this.jsonConfig.isUserConfigured() || this.headerConfig.isUserConfigured() || this.asyncConfig.isUserConfigured() || this.multiPartConfig.isUserConfigured() || this.webTestClientConfig.isUserConfigured() || this.paramConfig.isUserConfigured() || this.matcherConfig.isUserConfigured();
    }

    public DecoderConfig getDecoderConfig() {
        return this.decoderConfig;
    }

    public RestAssuredWebTestClientConfig decoderConfig(DecoderConfig decoderConfig) {
        AssertParameter.notNull((Object)this.encoderConfig, DecoderConfig.class);
        return new RestAssuredWebTestClientConfig(this.logConfig, this.encoderConfig, decoderConfig, this.sessionConfig, this.objectMapperConfig, this.jsonConfig, this.xmlConfig, this.headerConfig, this.asyncConfig, this.multiPartConfig, this.webTestClientConfig, this.paramConfig, this.matcherConfig);
    }

    public EncoderConfig getEncoderConfig() {
        return this.encoderConfig;
    }

    public RestAssuredWebTestClientConfig encoderConfig(EncoderConfig encoderConfig) {
        AssertParameter.notNull((Object)encoderConfig, (String)"EncoderConfig");
        return new RestAssuredWebTestClientConfig(this.logConfig, encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, this.jsonConfig, this.xmlConfig, this.headerConfig, this.asyncConfig, this.multiPartConfig, this.webTestClientConfig, this.paramConfig, this.matcherConfig);
    }

    public HeaderConfig getHeaderConfig() {
        return this.headerConfig;
    }

    public RestAssuredWebTestClientConfig headerConfig(HeaderConfig headerConfig) {
        AssertParameter.notNull((Object)headerConfig, (String)"HeaderConfig");
        return new RestAssuredWebTestClientConfig(this.logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, this.jsonConfig, this.xmlConfig, headerConfig, this.asyncConfig, this.multiPartConfig, this.webTestClientConfig, this.paramConfig, this.matcherConfig);
    }

    public JsonConfig getJsonConfig() {
        return this.jsonConfig;
    }

    public RestAssuredWebTestClientConfig jsonConfig(JsonConfig jsonConfig) {
        AssertParameter.notNull((Object)jsonConfig, (String)"JsonConfig");
        return new RestAssuredWebTestClientConfig(this.logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, jsonConfig, this.xmlConfig, this.headerConfig, this.asyncConfig, this.multiPartConfig, this.webTestClientConfig, this.paramConfig, this.matcherConfig);
    }

    public LogConfig getLogConfig() {
        return this.logConfig;
    }

    public RestAssuredWebTestClientConfig logConfig(LogConfig logConfig) {
        AssertParameter.notNull((Object)logConfig, (String)"Log config");
        return new RestAssuredWebTestClientConfig(logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, this.jsonConfig, this.xmlConfig, this.headerConfig, this.asyncConfig, this.multiPartConfig, this.webTestClientConfig, this.paramConfig, this.matcherConfig);
    }

    public ObjectMapperConfig getObjectMapperConfig() {
        return this.objectMapperConfig;
    }

    public RestAssuredWebTestClientConfig objectMapperConfig(ObjectMapperConfig objectMapperConfig) {
        AssertParameter.notNull((Object)objectMapperConfig, (String)"Object mapper config");
        return new RestAssuredWebTestClientConfig(this.logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, objectMapperConfig, this.jsonConfig, this.xmlConfig, this.headerConfig, this.asyncConfig, this.multiPartConfig, this.webTestClientConfig, this.paramConfig, this.matcherConfig);
    }

    public SessionConfig getSessionConfig() {
        return this.sessionConfig;
    }

    public RestAssuredWebTestClientConfig sessionConfig(SessionConfig sessionConfig) {
        AssertParameter.notNull((Object)sessionConfig, (String)"Session config");
        return new RestAssuredWebTestClientConfig(this.logConfig, this.encoderConfig, this.decoderConfig, sessionConfig, this.objectMapperConfig, this.jsonConfig, this.xmlConfig, this.headerConfig, this.asyncConfig, this.multiPartConfig, this.webTestClientConfig, this.paramConfig, this.matcherConfig);
    }

    public XmlConfig getXmlConfig() {
        return this.xmlConfig;
    }

    public RestAssuredWebTestClientConfig xmlConfig(XmlConfig xmlConfig) {
        AssertParameter.notNull((Object)xmlConfig, (String)"XmlConfig");
        return new RestAssuredWebTestClientConfig(this.logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, this.jsonConfig, xmlConfig, this.headerConfig, this.asyncConfig, this.multiPartConfig, this.webTestClientConfig, this.paramConfig, this.matcherConfig);
    }

    public AsyncConfig getAsyncConfig() {
        return this.asyncConfig;
    }

    public RestAssuredWebTestClientConfig asyncConfig(AsyncConfig asyncConfig) {
        AssertParameter.notNull((Object)asyncConfig, AsyncConfig.class);
        return new RestAssuredWebTestClientConfig(this.logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, this.jsonConfig, this.xmlConfig, this.headerConfig, asyncConfig, this.multiPartConfig, this.webTestClientConfig, this.paramConfig, this.matcherConfig);
    }

    public MultiPartConfig getMultiPartConfig() {
        return this.multiPartConfig;
    }

    public RestAssuredWebTestClientConfig multiPartConfig(MultiPartConfig multiPartConfig) {
        AssertParameter.notNull((Object)multiPartConfig, MultiPartConfig.class);
        return new RestAssuredWebTestClientConfig(this.logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, this.jsonConfig, this.xmlConfig, this.headerConfig, this.asyncConfig, multiPartConfig, this.webTestClientConfig, this.paramConfig, this.matcherConfig);
    }

    public ClientConfig getClientConfig() {
        return this.getWebTestClientConfig();
    }

    public RestAssuredWebTestClientConfig clientConfig(ClientConfig clientConfig) {
        if (!(clientConfig instanceof WebTestClientConfig)) {
            throw new IllegalArgumentException("Wrong ClientConfig type supplied");
        }
        return this.webTestClientConfig((WebTestClientConfig)clientConfig);
    }

    public RestAssuredWebTestClientConfig webTestClientConfig(WebTestClientConfig webTestClientConfig) {
        AssertParameter.notNull((Object)webTestClientConfig, WebTestClientConfig.class);
        return new RestAssuredWebTestClientConfig(this.logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, this.jsonConfig, this.xmlConfig, this.headerConfig, this.asyncConfig, this.multiPartConfig, webTestClientConfig, this.paramConfig, this.matcherConfig);
    }

    public ParamConfig getParamConfig() {
        return this.paramConfig;
    }

    public WebTestClientParamConfig getWebTestClientParamConfig() {
        return this.paramConfig;
    }

    public SpecificationConfig paramConfig(ParamConfig paramConfig) {
        if (!(paramConfig instanceof WebTestClientParamConfig)) {
            throw new IllegalArgumentException("Wrong ClientConfig type supplied");
        }
        return this.paramConfig((WebTestClientParamConfig)paramConfig);
    }

    public RestAssuredWebTestClientConfig paramConfig(WebTestClientParamConfig paramConfig) {
        AssertParameter.notNull((Object)((Object)paramConfig), MultiPartConfig.class);
        return new RestAssuredWebTestClientConfig(this.logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, this.jsonConfig, this.xmlConfig, this.headerConfig, this.asyncConfig, this.multiPartConfig, this.webTestClientConfig, paramConfig, this.matcherConfig);
    }

    public WebTestClientConfig getWebTestClientConfig() {
        return this.webTestClientConfig;
    }

    public MatcherConfig getMatcherConfig() {
        return this.matcherConfig;
    }

    public RestAssuredWebTestClientConfig matcherConfig(MatcherConfig matcherConfig) {
        AssertParameter.notNull((Object)matcherConfig, (String)"Matcher config");
        return new RestAssuredWebTestClientConfig(this.logConfig, this.encoderConfig, this.decoderConfig, this.sessionConfig, this.objectMapperConfig, this.jsonConfig, this.xmlConfig, this.headerConfig, this.asyncConfig, this.multiPartConfig, this.webTestClientConfig, this.paramConfig, matcherConfig);
    }
}

