/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.webtestclient.internal;

import io.restassured.config.LogConfig;
import io.restassured.internal.RestAssuredResponseOptionsImpl;
import io.restassured.internal.log.LogRepository;
import io.restassured.module.webtestclient.internal.ValidatableWebTestClientResponseImpl;
import io.restassured.module.webtestclient.response.ValidatableWebTestClientResponse;
import io.restassured.module.webtestclient.response.WebTestClientResponse;
import io.restassured.response.ExtractableResponse;
import org.springframework.test.web.reactive.server.WebTestClient;

public class WebTestClientRestAssuredResponseImpl
extends RestAssuredResponseOptionsImpl<WebTestClientResponse>
implements WebTestClientResponse {
    private final WebTestClient.ResponseSpec responseSpec;
    private final LogRepository logRepository;

    public WebTestClientRestAssuredResponseImpl(WebTestClient.ResponseSpec responseSpec, LogRepository logRepository) {
        this.responseSpec = responseSpec;
        this.logRepository = logRepository;
    }

    public ValidatableWebTestClientResponse then() {
        ValidatableWebTestClientResponseImpl response = new ValidatableWebTestClientResponseImpl(this.responseSpec, this.getRpr(), this.getConfig(), this, (ExtractableResponse<WebTestClientResponse>)this, this.logRepository);
        LogConfig logConfig = this.getConfig().getLogConfig();
        if (logConfig.isLoggingOfRequestAndResponseIfValidationFailsEnabled()) {
            response.log().ifValidationFails(logConfig.logDetailOfRequestAndResponseIfValidationFails(), logConfig.isPrettyPrintingEnabled());
        }
        return response;
    }
}

