/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.tcp.server.events;

import io.reactivex.netty.events.internal.SafeEventListener;
import io.reactivex.netty.protocol.tcp.server.events.TcpServerEventListener;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

final class SafeTcpServerEventListener
extends TcpServerEventListener
implements SafeEventListener {
    private final TcpServerEventListener delegate;
    private final AtomicBoolean completed = new AtomicBoolean();

    public SafeTcpServerEventListener(TcpServerEventListener delegate) {
        this.delegate = delegate;
    }

    public void onCompleted() {
        if (this.completed.compareAndSet(false, true)) {
            this.delegate.onCompleted();
        }
    }

    @Override
    public void onNewClientConnected() {
        if (!this.completed.get()) {
            this.delegate.onNewClientConnected();
        }
    }

    @Override
    public void onConnectionHandlingStart(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onConnectionHandlingStart(duration, timeUnit);
        }
    }

    @Override
    public void onConnectionHandlingSuccess(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onConnectionHandlingSuccess(duration, timeUnit);
        }
    }

    @Override
    public void onConnectionHandlingFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onConnectionHandlingFailed(duration, timeUnit, throwable);
        }
    }

    public void onByteRead(long bytesRead) {
        if (!this.completed.get()) {
            this.delegate.onByteRead(bytesRead);
        }
    }

    public void onByteWritten(long bytesWritten) {
        if (!this.completed.get()) {
            this.delegate.onByteWritten(bytesWritten);
        }
    }

    public void onFlushStart() {
        if (!this.completed.get()) {
            this.delegate.onFlushStart();
        }
    }

    public void onFlushComplete(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onFlushComplete(duration, timeUnit);
        }
    }

    public void onWriteStart() {
        if (!this.completed.get()) {
            this.delegate.onWriteStart();
        }
    }

    public void onWriteSuccess(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onWriteSuccess(duration, timeUnit);
        }
    }

    public void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onWriteFailed(duration, timeUnit, throwable);
        }
    }

    public void onConnectionCloseStart() {
        if (!this.completed.get()) {
            this.delegate.onConnectionCloseStart();
        }
    }

    public void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onConnectionCloseSuccess(duration, timeUnit);
        }
    }

    public void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onConnectionCloseFailed(duration, timeUnit, throwable);
        }
    }

    public void onCustomEvent(Object event) {
        if (!this.completed.get()) {
            this.delegate.onCustomEvent(event);
        }
    }

    public void onCustomEvent(Object event, long duration, TimeUnit timeUnit) {
        if (!this.completed.get()) {
            this.delegate.onCustomEvent(event, duration, timeUnit);
        }
    }

    public void onCustomEvent(Object event, long duration, TimeUnit timeUnit, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onCustomEvent(event, duration, timeUnit, throwable);
        }
    }

    public void onCustomEvent(Object event, Throwable throwable) {
        if (!this.completed.get()) {
            this.delegate.onCustomEvent(event, throwable);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafeTcpServerEventListener)) {
            return false;
        }
        SafeTcpServerEventListener that = (SafeTcpServerEventListener)((Object)o);
        return !(this.delegate == null ? that.delegate != null : !((Object)((Object)this.delegate)).equals((Object)that.delegate));
    }

    public int hashCode() {
        return this.delegate != null ? ((Object)((Object)this.delegate)).hashCode() : 0;
    }
}

