/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.tcp.client;

import io.reactivex.netty.client.ConnectionProvider;
import io.reactivex.netty.client.ConnectionRequest;
import io.reactivex.netty.protocol.tcp.client.ConnectionRequestImpl;
import io.reactivex.netty.protocol.tcp.client.InterceptingTcpClient;
import io.reactivex.netty.protocol.tcp.client.TcpClientInterceptorChain;
import io.reactivex.netty.protocol.tcp.client.TcpClientInterceptorChainImpl;
import io.reactivex.netty.protocol.tcp.client.events.TcpClientEventListener;
import io.reactivex.netty.protocol.tcp.client.events.TcpClientEventPublisher;
import rx.Subscription;

public class InterceptingTcpClientImpl<W, R>
extends InterceptingTcpClient<W, R> {
    private final ConnectionProvider<W, R> cp;
    private final TcpClientEventPublisher eventPublisher;
    private final ConnectionRequest<W, R> connectionRequest;

    public InterceptingTcpClientImpl(ConnectionProvider<W, R> cp, TcpClientEventPublisher ep) {
        this.cp = cp;
        this.eventPublisher = ep;
        this.connectionRequest = new ConnectionRequestImpl<W, R>(this.cp);
    }

    @Override
    public ConnectionRequest<W, R> createConnectionRequest() {
        return this.connectionRequest;
    }

    @Override
    public TcpClientInterceptorChain<W, R> intercept() {
        return new TcpClientInterceptorChainImpl<W, R>(this.cp, this.eventPublisher);
    }

    public Subscription subscribe(TcpClientEventListener listener) {
        return this.eventPublisher.subscribe(listener);
    }
}

