/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.flowables;

import io.reactivex.rxjava3.annotations.BackpressureKind;
import io.reactivex.rxjava3.annotations.BackpressureSupport;
import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.SchedulerSupport;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.internal.functions.ObjectHelper;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableAutoConnect;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableRefCount;
import io.reactivex.rxjava3.internal.util.ConnectConsumer;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;

public abstract class ConnectableFlowable<T>
extends Flowable<T> {
    public abstract void connect(@NonNull Consumer<? super Disposable> var1);

    public abstract void reset();

    public final Disposable connect() {
        ConnectConsumer cc = new ConnectConsumer();
        this.connect(cc);
        return cc.disposable;
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    @NonNull
    public Flowable<T> refCount() {
        return RxJavaPlugins.onAssembly(new FlowableRefCount(this));
    }

    @CheckReturnValue
    @SchedulerSupport(value="none")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    public final Flowable<T> refCount(int subscriberCount) {
        return this.refCount(subscriberCount, 0L, TimeUnit.NANOSECONDS, Schedulers.trampoline());
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    public final Flowable<T> refCount(long timeout, TimeUnit unit) {
        return this.refCount(1, timeout, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    public final Flowable<T> refCount(long timeout, TimeUnit unit, Scheduler scheduler) {
        return this.refCount(1, timeout, unit, scheduler);
    }

    @CheckReturnValue
    @SchedulerSupport(value="io.reactivex:computation")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    public final Flowable<T> refCount(int subscriberCount, long timeout, TimeUnit unit) {
        return this.refCount(subscriberCount, timeout, unit, Schedulers.computation());
    }

    @CheckReturnValue
    @SchedulerSupport(value="custom")
    @BackpressureSupport(value=BackpressureKind.PASS_THROUGH)
    public final Flowable<T> refCount(int subscriberCount, long timeout, TimeUnit unit, Scheduler scheduler) {
        ObjectHelper.verifyPositive(subscriberCount, "subscriberCount");
        ObjectHelper.requireNonNull(unit, "unit is null");
        ObjectHelper.requireNonNull(scheduler, "scheduler is null");
        return RxJavaPlugins.onAssembly(new FlowableRefCount(this, subscriberCount, timeout, unit, scheduler));
    }

    @NonNull
    public Flowable<T> autoConnect() {
        return this.autoConnect(1);
    }

    @NonNull
    public Flowable<T> autoConnect(int numberOfSubscribers) {
        return this.autoConnect(numberOfSubscribers, Functions.emptyConsumer());
    }

    @NonNull
    public Flowable<T> autoConnect(int numberOfSubscribers, @NonNull Consumer<? super Disposable> connection) {
        if (numberOfSubscribers <= 0) {
            this.connect(connection);
            return RxJavaPlugins.onAssembly(this);
        }
        return RxJavaPlugins.onAssembly(new FlowableAutoConnect(this, numberOfSubscribers, connection));
    }
}

