/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.QueueSubscription;
import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.operators.flowable.FlowableScalarXMap;
import io.reactivex.internal.queue.SpscArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSwitchMap<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super T, ? extends Publisher<? extends R>> mapper;
    final int bufferSize;
    final boolean delayErrors;

    public FlowableSwitchMap(Flowable<T> source, Function<? super T, ? extends Publisher<? extends R>> mapper, int bufferSize, boolean delayErrors) {
        super(source);
        this.mapper = mapper;
        this.bufferSize = bufferSize;
        this.delayErrors = delayErrors;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        if (FlowableScalarXMap.tryScalarXMapSubscribe(this.source, s, this.mapper)) {
            return;
        }
        this.source.subscribe(new SwitchMapSubscriber<T, R>(s, this.mapper, this.bufferSize, this.delayErrors));
    }

    static final class SwitchMapInnerSubscriber<T, R>
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<R> {
        private static final long serialVersionUID = 3837284832786408377L;
        final SwitchMapSubscriber<T, R> parent;
        final long index;
        final int bufferSize;
        volatile SimpleQueue<R> queue;
        volatile boolean done;
        int fusionMode;

        SwitchMapInnerSubscriber(SwitchMapSubscriber<T, R> parent, long index, int bufferSize) {
            this.parent = parent;
            this.index = index;
            this.bufferSize = bufferSize;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this, s)) {
                if (s instanceof QueueSubscription) {
                    QueueSubscription qs = (QueueSubscription)s;
                    int m = qs.requestFusion(7);
                    if (m == 1) {
                        this.fusionMode = m;
                        this.queue = qs;
                        this.done = true;
                        this.parent.drain();
                        return;
                    }
                    if (m == 2) {
                        this.fusionMode = m;
                        this.queue = qs;
                        s.request((long)this.bufferSize);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<R>(this.bufferSize);
                s.request((long)this.bufferSize);
            }
        }

        public void onNext(R t) {
            SwitchMapSubscriber<T, R> p = this.parent;
            if (this.index == p.unique) {
                if (this.fusionMode == 0 && !this.queue.offer(t)) {
                    this.onError(new MissingBackpressureException("Queue full?!"));
                    return;
                }
                p.drain();
            }
        }

        public void onError(Throwable t) {
            SwitchMapSubscriber<T, R> p = this.parent;
            if (this.index == p.unique && p.error.addThrowable(t)) {
                if (!p.delayErrors) {
                    p.upstream.cancel();
                    p.done = true;
                }
                this.done = true;
                p.drain();
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        public void onComplete() {
            SwitchMapSubscriber<T, R> p = this.parent;
            if (this.index == p.unique) {
                this.done = true;
                p.drain();
            }
        }

        public void cancel() {
            SubscriptionHelper.cancel(this);
        }

        public void request(long n) {
            if (this.fusionMode != 1) {
                ((Subscription)this.get()).request(n);
            }
        }
    }

    static final class SwitchMapSubscriber<T, R>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -3491074160481096299L;
        final Subscriber<? super R> downstream;
        final Function<? super T, ? extends Publisher<? extends R>> mapper;
        final int bufferSize;
        final boolean delayErrors;
        volatile boolean done;
        final AtomicThrowable error;
        volatile boolean cancelled;
        Subscription upstream;
        final AtomicReference<SwitchMapInnerSubscriber<T, R>> active = new AtomicReference();
        final AtomicLong requested = new AtomicLong();
        static final SwitchMapInnerSubscriber<Object, Object> CANCELLED = new SwitchMapInnerSubscriber(null, -1L, 1);
        volatile long unique;

        SwitchMapSubscriber(Subscriber<? super R> actual, Function<? super T, ? extends Publisher<? extends R>> mapper, int bufferSize, boolean delayErrors) {
            this.downstream = actual;
            this.mapper = mapper;
            this.bufferSize = bufferSize;
            this.delayErrors = delayErrors;
            this.error = new AtomicThrowable();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            Publisher<? extends R> p;
            long c;
            if (this.done) {
                return;
            }
            this.unique = c = this.unique + 1L;
            SwitchMapInnerSubscriber<T, R> inner = this.active.get();
            if (inner != null) {
                inner.cancel();
            }
            try {
                p = ObjectHelper.requireNonNull(this.mapper.apply(t), "The publisher returned is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.upstream.cancel();
                this.onError(e);
                return;
            }
            SwitchMapInnerSubscriber nextInner = new SwitchMapInnerSubscriber(this, c, this.bufferSize);
            while ((inner = this.active.get()) != CANCELLED) {
                if (!this.active.compareAndSet(inner, nextInner)) continue;
                p.subscribe(nextInner);
                break;
            }
        }

        public void onError(Throwable t) {
            if (!this.done && this.error.addThrowable(t)) {
                if (!this.delayErrors) {
                    this.disposeInner();
                }
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                if (this.unique == 0L) {
                    this.upstream.request(Long.MAX_VALUE);
                } else {
                    this.drain();
                }
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.cancel();
                this.disposeInner();
            }
        }

        void disposeInner() {
            SwitchMapInnerSubscriber<Object, Object> a = this.active.get();
            if (a != CANCELLED && (a = this.active.getAndSet(CANCELLED)) != CANCELLED && a != null) {
                a.cancel();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            Subscriber<? super R> a = this.downstream;
            int missing = 1;
            while (true) {
                SwitchMapInnerSubscriber<T, R> inner;
                SimpleQueue q;
                if (this.cancelled) {
                    this.active.lazySet(null);
                    return;
                }
                if (this.done) {
                    Throwable err;
                    if (this.delayErrors) {
                        if (this.active.get() == null) {
                            err = (Throwable)this.error.get();
                            if (err != null) {
                                a.onError(this.error.terminate());
                            } else {
                                a.onComplete();
                            }
                            return;
                        }
                    } else {
                        err = (Throwable)this.error.get();
                        if (err != null) {
                            this.disposeInner();
                            a.onError(this.error.terminate());
                            return;
                        }
                        if (this.active.get() == null) {
                            a.onComplete();
                            return;
                        }
                    }
                }
                SimpleQueue simpleQueue = q = (inner = this.active.get()) != null ? inner.queue : null;
                if (q != null) {
                    long e;
                    if (inner.done) {
                        if (!this.delayErrors) {
                            Throwable err = (Throwable)this.error.get();
                            if (err != null) {
                                this.disposeInner();
                                a.onError(this.error.terminate());
                                return;
                            }
                            if (q.isEmpty()) {
                                this.active.compareAndSet(inner, null);
                                continue;
                            }
                        } else if (q.isEmpty()) {
                            this.active.compareAndSet(inner, null);
                            continue;
                        }
                    }
                    long r = this.requested.get();
                    boolean retry = false;
                    for (e = 0L; e != r; ++e) {
                        boolean empty;
                        Object v;
                        if (this.cancelled) {
                            return;
                        }
                        boolean d = inner.done;
                        try {
                            v = q.poll();
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            inner.cancel();
                            this.error.addThrowable(ex);
                            d = true;
                            v = null;
                        }
                        boolean bl = empty = v == null;
                        if (inner != this.active.get()) {
                            retry = true;
                            break;
                        }
                        if (d) {
                            if (!this.delayErrors) {
                                Throwable err = (Throwable)this.error.get();
                                if (err != null) {
                                    a.onError(this.error.terminate());
                                    return;
                                }
                                if (empty) {
                                    this.active.compareAndSet(inner, null);
                                    retry = true;
                                    break;
                                }
                            } else if (empty) {
                                this.active.compareAndSet(inner, null);
                                retry = true;
                                break;
                            }
                        }
                        if (empty) break;
                        a.onNext(v);
                    }
                    if (e != 0L && !this.cancelled) {
                        if (r != Long.MAX_VALUE) {
                            this.requested.addAndGet(-e);
                        }
                        inner.request(e);
                    }
                    if (retry) continue;
                }
                if ((missing = this.addAndGet(-missing)) == 0) break;
            }
        }

        static {
            CANCELLED.cancel();
        }
    }
}

