/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ObservableUsing<T, D>
extends Observable<T> {
    final Callable<? extends D> resourceSupplier;
    final Function<? super D, ? extends ObservableSource<? extends T>> sourceSupplier;
    final Consumer<? super D> disposer;
    final boolean eager;

    public ObservableUsing(Callable<? extends D> resourceSupplier, Function<? super D, ? extends ObservableSource<? extends T>> sourceSupplier, Consumer<? super D> disposer, boolean eager) {
        this.resourceSupplier = resourceSupplier;
        this.sourceSupplier = sourceSupplier;
        this.disposer = disposer;
        this.eager = eager;
    }

    @Override
    public void subscribeActual(Observer<? super T> s) {
        ObservableSource<T> source;
        D resource;
        try {
            resource = this.resourceSupplier.call();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptyDisposable.error(e, s);
            return;
        }
        try {
            source = ObjectHelper.requireNonNull(this.sourceSupplier.apply(resource), "The sourceSupplier returned a null ObservableSource");
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            try {
                this.disposer.accept(resource);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                EmptyDisposable.error((Throwable)new CompositeException(e, ex), s);
                return;
            }
            EmptyDisposable.error(e, s);
            return;
        }
        UsingObserver<? super T, ? super D> us = new UsingObserver<T, D>(s, resource, this.disposer, this.eager);
        source.subscribe(us);
    }

    static final class UsingObserver<T, D>
    extends AtomicBoolean
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = 5904473792286235046L;
        final Observer<? super T> actual;
        final D resource;
        final Consumer<? super D> disposer;
        final boolean eager;
        Disposable s;

        UsingObserver(Observer<? super T> actual, D resource, Consumer<? super D> disposer, boolean eager) {
            this.actual = actual;
            this.resource = resource;
            this.disposer = disposer;
            this.eager = eager;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            this.actual.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            if (this.eager) {
                if (this.compareAndSet(false, true)) {
                    try {
                        this.disposer.accept(this.resource);
                    }
                    catch (Throwable e) {
                        Exceptions.throwIfFatal(e);
                        t = new CompositeException(t, e);
                    }
                }
                this.s.dispose();
                this.actual.onError(t);
            } else {
                this.actual.onError(t);
                this.s.dispose();
                this.disposeAfter();
            }
        }

        @Override
        public void onComplete() {
            if (this.eager) {
                if (this.compareAndSet(false, true)) {
                    try {
                        this.disposer.accept(this.resource);
                    }
                    catch (Throwable e) {
                        Exceptions.throwIfFatal(e);
                        this.actual.onError(e);
                        return;
                    }
                }
                this.s.dispose();
                this.actual.onComplete();
            } else {
                this.actual.onComplete();
                this.s.dispose();
                this.disposeAfter();
            }
        }

        @Override
        public void dispose() {
            this.disposeAfter();
            this.s.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.get();
        }

        void disposeAfter() {
            if (this.compareAndSet(false, true)) {
                try {
                    this.disposer.accept(this.resource);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    RxJavaPlugins.onError(e);
                }
            }
        }
    }
}

