/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.annotations.Experimental;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;

@Experimental
public final class SingleDetach<T>
extends Single<T> {
    final SingleSource<T> source;

    public SingleDetach(SingleSource<T> source) {
        this.source = source;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        this.source.subscribe(new DetachSingleObserver<T>(observer));
    }

    static final class DetachSingleObserver<T>
    implements SingleObserver<T>,
    Disposable {
        SingleObserver<? super T> actual;
        Disposable d;

        DetachSingleObserver(SingleObserver<? super T> actual) {
            this.actual = actual;
        }

        @Override
        public void dispose() {
            this.actual = null;
            this.d.dispose();
            this.d = DisposableHelper.DISPOSED;
        }

        @Override
        public boolean isDisposed() {
            return this.d.isDisposed();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.d, d)) {
                this.d = d;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            this.d = DisposableHelper.DISPOSED;
            SingleObserver<T> a = this.actual;
            if (a != null) {
                this.actual = null;
                a.onSuccess(value);
            }
        }

        @Override
        public void onError(Throwable e) {
            this.d = DisposableHelper.DISPOSED;
            SingleObserver<T> a = this.actual;
            if (a != null) {
                this.actual = null;
                a.onError(e);
            }
        }
    }
}

