/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.queue.MpscLinkedQueue;
import io.reactivex.internal.subscribers.QueueDrainSubscriber;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.QueueDrainHelper;
import io.reactivex.subscribers.SerializedSubscriber;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableBufferTimed<T, U extends Collection<? super T>>
extends AbstractFlowableWithUpstream<T, U> {
    final long timespan;
    final long timeskip;
    final TimeUnit unit;
    final Scheduler scheduler;
    final Callable<U> bufferSupplier;
    final int maxSize;
    final boolean restartTimerOnMaxSize;

    public FlowableBufferTimed(Flowable<T> source, long timespan, long timeskip, TimeUnit unit, Scheduler scheduler, Callable<U> bufferSupplier, int maxSize, boolean restartTimerOnMaxSize) {
        super(source);
        this.timespan = timespan;
        this.timeskip = timeskip;
        this.unit = unit;
        this.scheduler = scheduler;
        this.bufferSupplier = bufferSupplier;
        this.maxSize = maxSize;
        this.restartTimerOnMaxSize = restartTimerOnMaxSize;
    }

    @Override
    protected void subscribeActual(Subscriber<? super U> s) {
        if (this.timespan == this.timeskip && this.maxSize == Integer.MAX_VALUE) {
            this.source.subscribe(new BufferExactUnboundedSubscriber(new SerializedSubscriber<U>(s), this.bufferSupplier, this.timespan, this.unit, this.scheduler));
            return;
        }
        Scheduler.Worker w = this.scheduler.createWorker();
        if (this.timespan == this.timeskip) {
            this.source.subscribe(new BufferExactBoundedSubscriber(new SerializedSubscriber<U>(s), this.bufferSupplier, this.timespan, this.unit, this.maxSize, this.restartTimerOnMaxSize, w));
            return;
        }
        this.source.subscribe(new BufferSkipBoundedSubscriber(new SerializedSubscriber<U>(s), this.bufferSupplier, this.timespan, this.timeskip, this.unit, w));
    }

    static final class BufferExactBoundedSubscriber<T, U extends Collection<? super T>>
    extends QueueDrainSubscriber<T, U, U>
    implements Subscription,
    Runnable,
    Disposable {
        final Callable<U> bufferSupplier;
        final long timespan;
        final TimeUnit unit;
        final int maxSize;
        final boolean restartTimerOnMaxSize;
        final Scheduler.Worker w;
        U buffer;
        Disposable timer;
        Subscription s;
        long producerIndex;
        long consumerIndex;

        BufferExactBoundedSubscriber(Subscriber<? super U> actual, Callable<U> bufferSupplier, long timespan, TimeUnit unit, int maxSize, boolean restartOnMaxSize, Scheduler.Worker w) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.timespan = timespan;
            this.unit = unit;
            this.maxSize = maxSize;
            this.restartTimerOnMaxSize = restartOnMaxSize;
            this.w = w;
        }

        @Override
        public void onSubscribe(Subscription s) {
            Collection b;
            if (!SubscriptionHelper.validate(this.s, s)) {
                return;
            }
            this.s = s;
            try {
                b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The supplied buffer is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.w.dispose();
                s.cancel();
                EmptySubscription.error(e, this.actual);
                return;
            }
            this.buffer = b;
            this.actual.onSubscribe((Subscription)this);
            this.timer = this.w.schedulePeriodically(this, this.timespan, this.timespan, this.unit);
            s.request(Long.MAX_VALUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(T t) {
            Object b;
            BufferExactBoundedSubscriber bufferExactBoundedSubscriber = this;
            synchronized (bufferExactBoundedSubscriber) {
                b = this.buffer;
                if (b == null) {
                    return;
                }
                b.add(t);
                if (b.size() < this.maxSize) {
                    return;
                }
                this.buffer = null;
                ++this.producerIndex;
            }
            if (this.restartTimerOnMaxSize) {
                this.timer.dispose();
            }
            this.fastPathOrderedEmitMax(b, false, this);
            try {
                b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The supplied buffer is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.cancel();
                this.actual.onError(e);
                return;
            }
            bufferExactBoundedSubscriber = this;
            synchronized (bufferExactBoundedSubscriber) {
                this.buffer = b;
                ++this.consumerIndex;
            }
            if (this.restartTimerOnMaxSize) {
                this.timer = this.w.schedulePeriodically(this, this.timespan, this.timespan, this.unit);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable t) {
            BufferExactBoundedSubscriber bufferExactBoundedSubscriber = this;
            synchronized (bufferExactBoundedSubscriber) {
                this.buffer = null;
            }
            this.actual.onError(t);
            this.w.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            U b;
            BufferExactBoundedSubscriber bufferExactBoundedSubscriber = this;
            synchronized (bufferExactBoundedSubscriber) {
                b = this.buffer;
                this.buffer = null;
            }
            this.queue.offer(b);
            this.done = true;
            if (this.enter()) {
                QueueDrainHelper.drainMaxLoop(this.queue, this.actual, false, this, this);
            }
            this.w.dispose();
        }

        @Override
        public boolean accept(Subscriber<? super U> a, U v) {
            a.onNext(v);
            return true;
        }

        public void request(long n) {
            this.requested(n);
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            BufferExactBoundedSubscriber bufferExactBoundedSubscriber = this;
            synchronized (bufferExactBoundedSubscriber) {
                this.buffer = null;
            }
            this.s.cancel();
            this.w.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.w.isDisposed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            U current;
            Collection next;
            try {
                next = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The supplied buffer is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.cancel();
                this.actual.onError(e);
                return;
            }
            BufferExactBoundedSubscriber bufferExactBoundedSubscriber = this;
            synchronized (bufferExactBoundedSubscriber) {
                current = this.buffer;
                if (current == null || this.producerIndex != this.consumerIndex) {
                    return;
                }
                this.buffer = next;
            }
            this.fastPathOrderedEmitMax(current, false, this);
        }
    }

    static final class BufferSkipBoundedSubscriber<T, U extends Collection<? super T>>
    extends QueueDrainSubscriber<T, U, U>
    implements Subscription,
    Runnable {
        final Callable<U> bufferSupplier;
        final long timespan;
        final long timeskip;
        final TimeUnit unit;
        final Scheduler.Worker w;
        final List<U> buffers;
        Subscription s;

        BufferSkipBoundedSubscriber(Subscriber<? super U> actual, Callable<U> bufferSupplier, long timespan, long timeskip, TimeUnit unit, Scheduler.Worker w) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.timespan = timespan;
            this.timeskip = timeskip;
            this.unit = unit;
            this.w = w;
            this.buffers = new LinkedList<U>();
        }

        @Override
        public void onSubscribe(Subscription s) {
            Collection b;
            if (!SubscriptionHelper.validate(this.s, s)) {
                return;
            }
            this.s = s;
            try {
                b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The supplied buffer is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.w.dispose();
                s.cancel();
                EmptySubscription.error(e, this.actual);
                return;
            }
            this.buffers.add(b);
            this.actual.onSubscribe((Subscription)this);
            s.request(Long.MAX_VALUE);
            this.w.schedulePeriodically(this, this.timeskip, this.timeskip, this.unit);
            this.w.schedule(new RemoveFromBuffer(this, b), this.timespan, this.unit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(T t) {
            BufferSkipBoundedSubscriber bufferSkipBoundedSubscriber = this;
            synchronized (bufferSkipBoundedSubscriber) {
                for (Collection b : this.buffers) {
                    b.add(t);
                }
            }
        }

        public void onError(Throwable t) {
            this.done = true;
            this.w.dispose();
            this.clear();
            this.actual.onError(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            ArrayList<U> bs;
            BufferSkipBoundedSubscriber bufferSkipBoundedSubscriber = this;
            synchronized (bufferSkipBoundedSubscriber) {
                bs = new ArrayList<U>(this.buffers);
                this.buffers.clear();
            }
            for (Collection b : bs) {
                this.queue.offer(b);
            }
            this.done = true;
            if (this.enter()) {
                QueueDrainHelper.drainMaxLoop(this.queue, this.actual, false, this.w, this);
            }
        }

        public void request(long n) {
            this.requested(n);
        }

        public void cancel() {
            this.clear();
            this.s.cancel();
            this.w.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            BufferSkipBoundedSubscriber bufferSkipBoundedSubscriber = this;
            synchronized (bufferSkipBoundedSubscriber) {
                this.buffers.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Collection b;
            if (this.cancelled) {
                return;
            }
            try {
                b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The supplied buffer is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.cancel();
                this.actual.onError(e);
                return;
            }
            BufferSkipBoundedSubscriber bufferSkipBoundedSubscriber = this;
            synchronized (bufferSkipBoundedSubscriber) {
                if (this.cancelled) {
                    return;
                }
                this.buffers.add(b);
            }
            this.w.schedule(new RemoveFromBuffer(this, b), this.timespan, this.unit);
        }

        @Override
        public boolean accept(Subscriber<? super U> a, U v) {
            a.onNext(v);
            return true;
        }

        static final class RemoveFromBuffer
        implements Runnable {
            private final U buffer;
            final /* synthetic */ BufferSkipBoundedSubscriber this$0;

            RemoveFromBuffer(U buffer) {
                this.this$0 = this$0;
                this.buffer = buffer;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferSkipBoundedSubscriber bufferSkipBoundedSubscriber = this.this$0;
                synchronized (bufferSkipBoundedSubscriber) {
                    this.this$0.buffers.remove(this.buffer);
                }
                this.this$0.fastPathOrderedEmitMax(this.buffer, false, this.this$0.w);
            }
        }
    }

    static final class BufferExactUnboundedSubscriber<T, U extends Collection<? super T>>
    extends QueueDrainSubscriber<T, U, U>
    implements Subscription,
    Runnable,
    Disposable {
        final Callable<U> bufferSupplier;
        final long timespan;
        final TimeUnit unit;
        final Scheduler scheduler;
        Subscription s;
        U buffer;
        final AtomicReference<Disposable> timer = new AtomicReference();

        BufferExactUnboundedSubscriber(Subscriber<? super U> actual, Callable<U> bufferSupplier, long timespan, TimeUnit unit, Scheduler scheduler) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.timespan = timespan;
            this.unit = unit;
            this.scheduler = scheduler;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                Collection b;
                this.s = s;
                try {
                    b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The supplied buffer is null");
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.cancel();
                    EmptySubscription.error(e, this.actual);
                    return;
                }
                this.buffer = b;
                this.actual.onSubscribe((Subscription)this);
                if (!this.cancelled) {
                    s.request(Long.MAX_VALUE);
                    Disposable d = this.scheduler.schedulePeriodicallyDirect(this, this.timespan, this.timespan, this.unit);
                    if (!this.timer.compareAndSet(null, d)) {
                        d.dispose();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(T t) {
            BufferExactUnboundedSubscriber bufferExactUnboundedSubscriber = this;
            synchronized (bufferExactUnboundedSubscriber) {
                U b = this.buffer;
                if (b != null) {
                    b.add(t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable t) {
            DisposableHelper.dispose(this.timer);
            BufferExactUnboundedSubscriber bufferExactUnboundedSubscriber = this;
            synchronized (bufferExactUnboundedSubscriber) {
                this.buffer = null;
            }
            this.actual.onError(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            U b;
            DisposableHelper.dispose(this.timer);
            BufferExactUnboundedSubscriber bufferExactUnboundedSubscriber = this;
            synchronized (bufferExactUnboundedSubscriber) {
                b = this.buffer;
                if (b == null) {
                    return;
                }
                this.buffer = null;
            }
            this.queue.offer(b);
            this.done = true;
            if (this.enter()) {
                QueueDrainHelper.drainMaxLoop(this.queue, this.actual, false, this, this);
            }
        }

        public void request(long n) {
            this.requested(n);
        }

        public void cancel() {
            this.s.cancel();
            DisposableHelper.dispose(this.timer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            U current;
            Collection next;
            try {
                next = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The supplied buffer is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.cancel();
                this.actual.onError(e);
                return;
            }
            BufferExactUnboundedSubscriber bufferExactUnboundedSubscriber = this;
            synchronized (bufferExactUnboundedSubscriber) {
                current = this.buffer;
                if (current != null) {
                    this.buffer = next;
                }
            }
            if (current == null) {
                DisposableHelper.dispose(this.timer);
                return;
            }
            this.fastPathEmitMax(current, false, this);
        }

        @Override
        public boolean accept(Subscriber<? super U> a, U v) {
            this.actual.onNext(v);
            return true;
        }

        @Override
        public void dispose() {
            this.cancel();
        }

        @Override
        public boolean isDisposed() {
            return this.timer.get() == DisposableHelper.DISPOSED;
        }
    }
}

