/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.fuseable.FuseToObservable;
import io.reactivex.internal.operators.observable.ObservableFlatMapCompletable;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableFlatMapCompletableCompletable<T>
extends Completable
implements FuseToObservable<T> {
    final ObservableSource<T> source;
    final Function<? super T, ? extends CompletableSource> mapper;
    final boolean delayErrors;

    public ObservableFlatMapCompletableCompletable(ObservableSource<T> source, Function<? super T, ? extends CompletableSource> mapper, boolean delayErrors) {
        this.source = source;
        this.mapper = mapper;
        this.delayErrors = delayErrors;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        this.source.subscribe(new FlatMapCompletableMainObserver<T>(observer, this.mapper, this.delayErrors));
    }

    @Override
    public Observable<T> fuseToObservable() {
        return RxJavaPlugins.onAssembly(new ObservableFlatMapCompletable<T>(this.source, this.mapper, this.delayErrors));
    }

    static final class FlatMapCompletableMainObserver<T>
    extends AtomicInteger
    implements Disposable,
    Observer<T> {
        private static final long serialVersionUID = 8443155186132538303L;
        final CompletableObserver actual;
        final AtomicThrowable errors;
        final Function<? super T, ? extends CompletableSource> mapper;
        final boolean delayErrors;
        final CompositeDisposable set;
        Disposable d;

        FlatMapCompletableMainObserver(CompletableObserver observer, Function<? super T, ? extends CompletableSource> mapper, boolean delayErrors) {
            this.actual = observer;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.errors = new AtomicThrowable();
            this.set = new CompositeDisposable();
            this.lazySet(1);
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.d, d)) {
                this.d = d;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T value) {
            CompletableSource cs;
            try {
                cs = ObjectHelper.requireNonNull(this.mapper.apply(value), "The mapper returned a null CompletableSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.d.dispose();
                this.onError(ex);
                return;
            }
            this.getAndIncrement();
            InnerObserver inner = new InnerObserver();
            this.set.add(inner);
            cs.subscribe(inner);
        }

        @Override
        public void onError(Throwable e) {
            if (this.errors.addThrowable(e)) {
                if (this.delayErrors) {
                    if (this.decrementAndGet() == 0) {
                        Throwable ex = this.errors.terminate();
                        this.actual.onError(ex);
                        return;
                    }
                } else {
                    this.dispose();
                    if (this.getAndSet(0) > 0) {
                        Throwable ex = this.errors.terminate();
                        this.actual.onError(ex);
                        return;
                    }
                }
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void onComplete() {
            if (this.decrementAndGet() == 0) {
                Throwable ex = this.errors.terminate();
                if (ex != null) {
                    this.actual.onError(ex);
                } else {
                    this.actual.onComplete();
                }
            }
        }

        @Override
        public void dispose() {
            this.d.dispose();
            this.set.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.d.isDisposed();
        }

        void innerComplete(InnerObserver inner) {
            this.set.delete(inner);
            this.onComplete();
        }

        void innerError(InnerObserver inner, Throwable e) {
            this.set.delete(inner);
            this.onError(e);
        }

        final class InnerObserver
        extends AtomicReference<Disposable>
        implements CompletableObserver,
        Disposable {
            private static final long serialVersionUID = 8606673141535671828L;

            InnerObserver() {
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(this, d);
            }

            @Override
            public void onComplete() {
                FlatMapCompletableMainObserver.this.innerComplete(this);
            }

            @Override
            public void onError(Throwable e) {
                FlatMapCompletableMainObserver.this.innerError(this, e);
            }

            @Override
            public void dispose() {
                DisposableHelper.dispose(this);
            }

            @Override
            public boolean isDisposed() {
                return DisposableHelper.isDisposed((Disposable)this.get());
            }
        }
    }
}

