/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.subscribers.SerializedSubscriber;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSamplePublisher<T>
extends Flowable<T> {
    final Publisher<T> source;
    final Publisher<?> other;

    public FlowableSamplePublisher(Publisher<T> source, Publisher<?> other) {
        this.source = source;
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        SerializedSubscriber<? super T> serial = new SerializedSubscriber<T>(s);
        this.source.subscribe(new SamplePublisherSubscriber<T>(serial, this.other));
    }

    static final class SamplerSubscriber<T>
    implements Subscriber<Object> {
        final SamplePublisherSubscriber<T> parent;

        SamplerSubscriber(SamplePublisherSubscriber<T> parent) {
            this.parent = parent;
        }

        public void onSubscribe(Subscription s) {
            if (this.parent.setOther(s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(Object t) {
            this.parent.emit();
        }

        public void onError(Throwable t) {
            this.parent.error(t);
        }

        public void onComplete() {
            this.parent.complete();
        }
    }

    static final class SamplePublisherSubscriber<T>
    extends AtomicReference<T>
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = -3517602651313910099L;
        final Subscriber<? super T> actual;
        final Publisher<?> sampler;
        final AtomicLong requested = new AtomicLong();
        final AtomicReference<Subscription> other = new AtomicReference();
        Subscription s;

        SamplePublisherSubscriber(Subscriber<? super T> actual, Publisher<?> other) {
            this.actual = actual;
            this.sampler = other;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                if (this.other.get() == null) {
                    this.sampler.subscribe(new SamplerSubscriber(this));
                    s.request(Long.MAX_VALUE);
                }
            }
        }

        public void onNext(T t) {
            this.lazySet(t);
        }

        public void onError(Throwable t) {
            SubscriptionHelper.cancel(this.other);
            this.actual.onError(t);
        }

        public void onComplete() {
            SubscriptionHelper.cancel(this.other);
            this.actual.onComplete();
        }

        boolean setOther(Subscription o) {
            return SubscriptionHelper.setOnce(this.other, o);
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
            }
        }

        public void cancel() {
            SubscriptionHelper.cancel(this.other);
            this.s.cancel();
        }

        public void error(Throwable e) {
            this.cancel();
            this.actual.onError(e);
        }

        public void complete() {
            this.cancel();
            this.actual.onComplete();
        }

        public void emit() {
            Object value = this.getAndSet(null);
            if (value != null) {
                long r = this.requested.get();
                if (r != 0L) {
                    this.actual.onNext(value);
                    BackpressureHelper.produced(this.requested, 1L);
                } else {
                    this.cancel();
                    this.actual.onError((Throwable)new MissingBackpressureException("Couldn't emit value due to lack of requests!"));
                }
            }
        }
    }
}

