/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.internal.operators.OperatorTimeoutBase;
import rx.schedulers.Schedulers;
import rx.subscriptions.Subscriptions;

public class OperatorTimeoutWithSelector<T, U, V>
extends OperatorTimeoutBase<T> {
    public OperatorTimeoutWithSelector(final Func0<? extends Observable<U>> firstTimeoutSelector, final Func1<? super T, ? extends Observable<V>> timeoutSelector, Observable<? extends T> other) {
        super(new OperatorTimeoutBase.FirstTimeoutStub<T>(){

            @Override
            public Subscription call(final OperatorTimeoutBase.TimeoutSubscriber<T> timeoutSubscriber, final Long seqId, Scheduler.Worker inner) {
                if (firstTimeoutSelector != null) {
                    Observable o = null;
                    try {
                        o = (Observable)firstTimeoutSelector.call();
                    }
                    catch (Throwable t) {
                        Exceptions.throwIfFatal(t);
                        timeoutSubscriber.onError(t);
                        return Subscriptions.empty();
                    }
                    return o.unsafeSubscribe(new Subscriber<U>(){

                        @Override
                        public void onCompleted() {
                            timeoutSubscriber.onTimeout(seqId);
                        }

                        @Override
                        public void onError(Throwable e) {
                            timeoutSubscriber.onError(e);
                        }

                        @Override
                        public void onNext(U t) {
                            timeoutSubscriber.onTimeout(seqId);
                        }
                    });
                }
                return Subscriptions.empty();
            }
        }, new OperatorTimeoutBase.TimeoutStub<T>(){

            @Override
            public Subscription call(final OperatorTimeoutBase.TimeoutSubscriber<T> timeoutSubscriber, final Long seqId, T value, Scheduler.Worker inner) {
                Observable o = null;
                try {
                    o = (Observable)timeoutSelector.call(value);
                }
                catch (Throwable t) {
                    Exceptions.throwIfFatal(t);
                    timeoutSubscriber.onError(t);
                    return Subscriptions.empty();
                }
                return o.unsafeSubscribe(new Subscriber<V>(){

                    @Override
                    public void onCompleted() {
                        timeoutSubscriber.onTimeout(seqId);
                    }

                    @Override
                    public void onError(Throwable e) {
                        timeoutSubscriber.onError(e);
                    }

                    @Override
                    public void onNext(V t) {
                        timeoutSubscriber.onTimeout(seqId);
                    }
                });
            }
        }, other, Schedulers.immediate());
    }
}

