/*
 * Decompiled with CFR 0.152.
 */
package ratpack.test.embed;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import ratpack.func.Action;
import ratpack.test.embed.internal.JarFileEphemeralBaseDir;
import ratpack.test.embed.internal.PathEphemeralBaseDir;
import ratpack.util.Exceptions;

public interface EphemeralBaseDir
extends AutoCloseable {
    public static EphemeralBaseDir tmpDir() {
        return EphemeralBaseDir.dir(com.google.common.io.Files.createTempDir());
    }

    public static EphemeralBaseDir dir(File dir) {
        return new PathEphemeralBaseDir(dir);
    }

    public static EphemeralBaseDir tmpJar() {
        return EphemeralBaseDir.jar((File)Exceptions.uncheck(() -> File.createTempFile("ratpack", ".jar")));
    }

    public static EphemeralBaseDir jar(File jarFile) {
        return new JarFileEphemeralBaseDir(jarFile);
    }

    default public EphemeralBaseDir closeOnExit() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    EphemeralBaseDir.this.close();
                }
                catch (IOException e) {
                    throw Exceptions.uncheck((Throwable)e);
                }
            }
        });
        return this;
    }

    default public void use(Action<? super EphemeralBaseDir> action) throws Exception {
        try {
            action.execute((Object)this);
        }
        finally {
            this.close();
        }
    }

    default public Path path(String path) {
        Path pathObj = this.getRoot().resolve(path);
        Exceptions.uncheck(() -> Files.createDirectories(pathObj.getParent(), new FileAttribute[0]));
        return pathObj;
    }

    default public Path write(String path, String content) {
        Path file = this.path(path);
        Exceptions.uncheck(() -> {
            Files.write(file, content.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            Files.setLastModifiedTime(file, FileTime.fromMillis(System.currentTimeMillis()));
        });
        return file;
    }

    default public Path mkdir(String path) {
        return (Path)Exceptions.uncheck(() -> Files.createDirectories(this.getRoot().resolve(path), new FileAttribute[0]));
    }

    public Path getRoot();

    @Override
    public void close() throws IOException;
}

