/*
 * Decompiled with CFR 0.152.
 */
package ratpack.test.embed;

import java.net.URI;
import org.slf4j.LoggerFactory;
import ratpack.func.Action;
import ratpack.func.Factory;
import ratpack.func.Function;
import ratpack.handling.Chain;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.registry.Registry;
import ratpack.server.RatpackServer;
import ratpack.server.RatpackServerSpec;
import ratpack.server.ServerConfig;
import ratpack.server.ServerConfigBuilder;
import ratpack.server.internal.EmbeddedRatpackServerSpec;
import ratpack.test.CloseableApplicationUnderTest;
import ratpack.test.embed.internal.EmbeddedAppSupport;
import ratpack.util.Exceptions;

public interface EmbeddedApp
extends CloseableApplicationUnderTest {
    public static EmbeddedApp fromServer(RatpackServer server) {
        return EmbeddedApp.fromServer((Factory<? extends RatpackServer>)((Factory)() -> server));
    }

    public static EmbeddedApp of(Action<? super RatpackServerSpec> definition) throws Exception {
        return EmbeddedApp.fromServer(RatpackServer.of(d -> definition.execute((Object)new EmbeddedRatpackServerSpec(d))));
    }

    public static EmbeddedApp fromServer(final Factory<? extends RatpackServer> server) {
        return new EmbeddedAppSupport(){

            @Override
            protected RatpackServer createServer() throws Exception {
                return (RatpackServer)server.create();
            }
        };
    }

    public static EmbeddedApp fromServer(ServerConfigBuilder serverConfig, Action<? super RatpackServerSpec> definition) {
        return EmbeddedApp.fromServer(serverConfig.build(), definition);
    }

    public static EmbeddedApp fromServer(ServerConfig serverConfig, Action<? super RatpackServerSpec> definition) {
        return EmbeddedApp.fromServer((RatpackServer)Exceptions.uncheck(() -> RatpackServer.of(b -> definition.execute((Object)b.serverConfig(serverConfig)))));
    }

    public static EmbeddedApp fromHandlerFactory(Function<? super Registry, ? extends Handler> handlerFactory) {
        return EmbeddedApp.fromServer(ServerConfig.embedded().build(), (Action<? super RatpackServerSpec>)((Action)b -> b.handler(handlerFactory)));
    }

    public static EmbeddedApp fromHandler(Handler handler) {
        return EmbeddedApp.fromServer(ServerConfig.embedded().build(), (Action<? super RatpackServerSpec>)((Action)b -> b.handler(r -> handler)));
    }

    public static EmbeddedApp fromHandlers(Action<? super Chain> action) {
        return EmbeddedApp.fromServer(ServerConfig.embedded().build(), (Action<? super RatpackServerSpec>)((Action)b -> b.handler(r -> Handlers.chain((ServerConfig)((ServerConfig)r.get(ServerConfig.class)), (Registry)r, (Action)action))));
    }

    public RatpackServer getServer();

    @Override
    default public URI getAddress() {
        RatpackServer server = this.getServer();
        try {
            if (!server.isRunning()) {
                server.start();
            }
            return new URI(server.getScheme(), null, server.getBindHost(), server.getBindPort(), "/", null, null);
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
    }

    @Override
    default public void close() {
        try {
            this.getServer().stop();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("", (Throwable)e);
        }
    }
}

