/*
 * Decompiled with CFR 0.152.
 */
package ratpack.spring.config;

import com.google.inject.Module;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.guice.BindingsSpec;
import ratpack.guice.Guice;
import ratpack.registry.Registry;
import ratpack.server.RatpackServer;
import ratpack.server.ServerConfig;
import ratpack.server.ServerConfigBuilder;
import ratpack.spring.Spring;
import ratpack.spring.config.RatpackProperties;
import ratpack.spring.config.RatpackServerCustomizer;
import ratpack.spring.config.internal.ChainConfigurers;

@Configuration
@Import(value={ChainConfigurers.class})
@EnableConfigurationProperties(value={RatpackProperties.class})
public class RatpackConfiguration
implements CommandLineRunner,
DisposableBean {
    @Autowired
    private RatpackServer server;

    public void run(String ... args) throws Exception {
        this.server.start();
    }

    @Deprecated
    public void stop() throws Exception {
        this.destroy();
    }

    public void destroy() throws Exception {
        this.server.stop();
    }

    @Configuration
    protected static class ServerConfiguration {
        @Autowired
        private ServerConfig serverConfig;
        @Autowired
        private ChainConfigurers chainConfigurers;
        @Autowired(required=false)
        private List<RatpackServerCustomizer> customizers = Collections.emptyList();

        protected ServerConfiguration() {
        }

        @Bean
        public RatpackServer ratpackServer(ApplicationContext context) throws Exception {
            return RatpackServer.of(ratpackServerSpec -> ratpackServerSpec.serverConfig(this.serverConfig).registry(this.joinedRegistry(context)).handlers((Action)this.chainConfigurers));
        }

        private Function<Registry, Registry> joinedRegistry(ApplicationContext context) throws Exception {
            return baseRegistry -> ((Registry)Guice.registry(bindingSpec -> {
                context.getBeansOfType(Module.class).values().forEach(arg_0 -> ((BindingsSpec)bindingSpec).module(arg_0));
                for (RatpackServerCustomizer customizer : this.customizers) {
                    customizer.getBindings().execute(bindingSpec);
                }
            }).apply(baseRegistry)).join(Spring.spring((ListableBeanFactory)context));
        }
    }

    @Configuration
    protected static class ServerConfigConfiguration {
        @Autowired
        private RatpackProperties ratpack;
        @Autowired(required=false)
        private List<RatpackServerCustomizer> customizers = Collections.emptyList();

        protected ServerConfigConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public ServerConfig ratpackServerConfig() throws Exception {
            ServerConfigBuilder serverConfigBuilder = ServerConfig.builder().baseDir(this.ratpack.getBasepath()).address(this.ratpack.getAddress()).threads(this.ratpack.getMaxThreads());
            if (this.ratpack.getPort() != null) {
                serverConfigBuilder.port(this.ratpack.getPort().intValue());
            }
            for (RatpackServerCustomizer customizer : this.customizers) {
                customizer.getServerConfig().execute((Object)serverConfigBuilder);
            }
            return serverConfigBuilder.build();
        }
    }
}

